import { NodeStatus, StateMachine, } from "@zwave-js/core";
function to(state) {
    return { newState: state };
}
const statusDict = {
    unknown: NodeStatus.Unknown,
    dead: NodeStatus.Dead,
    alive: NodeStatus.Alive,
    asleep: NodeStatus.Asleep,
    awake: NodeStatus.Awake,
};
export function nodeStatusMachineStateToNodeStatus(state) {
    return statusDict[state] ?? NodeStatus.Unknown;
}
export function createNodeStatusMachine(node) {
    const initialState = {
        value: "unknown",
    };
    const transitions = (state) => (input) => {
        switch (state.value) {
            case "unknown": {
                switch (input.value) {
                    case "DEAD":
                        if (!node.canSleep)
                            return to({ value: "dead" });
                        break;
                    case "ALIVE":
                        if (!node.canSleep)
                            return to({ value: "alive" });
                        break;
                    case "ASLEEP":
                        if (node.canSleep)
                            return to({ value: "asleep" });
                        break;
                    case "AWAKE":
                        if (node.canSleep)
                            return to({ value: "awake" });
                        break;
                }
                break;
            }
            case "dead": {
                if (input.value === "ALIVE")
                    return to({ value: "alive" });
                break;
            }
            case "alive": {
                switch (input.value) {
                    case "DEAD":
                        return to({ value: "dead" });
                    // GH#1054 we must have a way to send a node to sleep even if
                    // it was previously detected as a non-sleeping device
                    case "ASLEEP": {
                        if (node.canSleep)
                            return to({ value: "asleep" });
                        break;
                    }
                    case "AWAKE": {
                        if (node.canSleep)
                            return to({ value: "awake" });
                        break;
                    }
                }
                break;
            }
            case "asleep": {
                if (input.value === "AWAKE")
                    return to({ value: "awake" });
                break;
            }
            case "awake": {
                if (input.value === "ASLEEP") {
                    return to({ value: "asleep" });
                }
                break;
            }
        }
    };
    return new StateMachine(initialState, transitions);
}
//# sourceMappingURL=NodeStatusMachine.js.map