import { type SetValueAPIOptions, type SetValueResult } from "@zwave-js/cc";
import { type Protocols, SecurityClass, type TranslatedValueID, type ValueID, type ValueMetadata } from "@zwave-js/core";
import type { Driver } from "../driver/Driver.js";
import type { ZWaveNode } from "./Node.js";
import { VirtualEndpoint } from "./VirtualEndpoint.js";
export interface VirtualValueID extends TranslatedValueID {
    /** The metadata that belongs to this virtual value ID */
    metadata: ValueMetadata;
    /** The maximum supported CC version among all nodes targeted by this virtual value ID */
    ccVersion: number;
}
export declare enum CommunicationProfile {
    Mesh_S2_Unauthenticated = 0,
    Mesh_S2_Authenticated = 1,
    Mesh_S2_AccessControl = 2,
    Mesh_S0_Legacy = 7,
    LR_S2_Authenticated = 17,
    LR_S2_AccessControl = 18
}
export declare function getCommunicationProfile(protocol: Protocols, securityClass: SecurityClass): CommunicationProfile;
export declare function getSecurityClassFromCommunicationProfile(profile: CommunicationProfile): SecurityClass;
export declare class VirtualNode extends VirtualEndpoint {
    readonly id: number | undefined;
    constructor(id: number | undefined, driver: Driver, 
    /** The references to the physical node this virtual node abstracts */
    physicalNodes: Iterable<ZWaveNode>);
    readonly physicalNodes: readonly ZWaveNode[];
    readonly nodesByCommunicationProfile: ReadonlyMap<CommunicationProfile, ZWaveNode[]>;
    get hasMixedCommunicationProfiles(): boolean;
    /**
     * Updates a value for a given property of a given CommandClass.
     * This will communicate with the physical node(s) this virtual node represents!
     */
    setValue(valueId: ValueID, value: unknown, options?: SetValueAPIOptions): Promise<SetValueResult>;
    /**
     * Returns a list of all value IDs and their metadata that can be used to
     * control the physical node(s) this virtual node represents.
     */
    getDefinedValueIDs(): VirtualValueID[];
    /** Cache for this node's endpoint instances */
    private _endpointInstances;
    /**
     * Returns an endpoint of this node with the given index. 0 returns the node itself.
     */
    getEndpoint(index: 0): VirtualEndpoint;
    getEndpoint(index: number): VirtualEndpoint | undefined;
    getEndpointOrThrow(index: number): VirtualEndpoint;
    /** Returns the current endpoint count of this virtual node (the maximum in the list of physical nodes) */
    getEndpointCount(): number;
    private get isMultiChannelInterviewComplete();
}
//# sourceMappingURL=VirtualNode.d.ts.map