import { type CommandClasses, type MaybeNotKnown, ValueDB, type ValueID, ValueMetadata } from "@zwave-js/core";
import type { Driver } from "../../driver/Driver.js";
import type { DeviceClass } from "../DeviceClass.js";
import type { ZWaveNodeValueEventCallbacks } from "../_Types.js";
import { NodeWakeupMixin } from "./30_Wakeup.js";
/** Defines functionality of Z-Wave nodes related to the value DB */
export interface NodeValues {
    /**
     * Retrieves a stored value for a given value id.
     * This does not request an updated value from the node!
     */
    getValue<T = unknown>(valueId: ValueID): MaybeNotKnown<T>;
    /**
     * Returns when the given value id was last updated by an update from the node.
     */
    getValueTimestamp(valueId: ValueID): MaybeNotKnown<number>;
    /**
     * Retrieves metadata for a given value id.
     * This can be used to enhance the user interface of an application
     */
    getValueMetadata(valueId: ValueID): ValueMetadata;
}
export declare abstract class NodeValuesMixin extends NodeWakeupMixin implements NodeValues {
    constructor(nodeId: number, driver: Driver, endpointIndex: number, deviceClass?: DeviceClass, supportedCCs?: CommandClasses[], valueDB?: ValueDB);
    protected _valueDB: ValueDB;
    get valueDB(): ValueDB;
    getValue<T = unknown>(valueId: ValueID): MaybeNotKnown<T>;
    getValueTimestamp(valueId: ValueID): MaybeNotKnown<number>;
    getValueMetadata(valueId: ValueID): ValueMetadata;
    /**
     * Enhances the raw event args of the ValueDB so it can be consumed better by applications
     */
    protected translateValueEvent<T extends ValueID>(eventName: keyof ZWaveNodeValueEventCallbacks, arg: T): void;
}
//# sourceMappingURL=40_Values.d.ts.map