import { type ZWavePlusNodeType, type ZWavePlusRoleType } from "@zwave-js/cc";
import type { MaybeNotKnown } from "@zwave-js/core";
import { NodeValuesMixin } from "./40_Values.js";
export interface NodeCapabilityValues {
    get manufacturerId(): MaybeNotKnown<number>;
    get productId(): MaybeNotKnown<number>;
    get productType(): MaybeNotKnown<number>;
    get firmwareVersion(): MaybeNotKnown<string>;
    get hardwareVersion(): MaybeNotKnown<number>;
    get sdkVersion(): MaybeNotKnown<string>;
    get zwavePlusVersion(): MaybeNotKnown<number>;
    get zwavePlusNodeType(): MaybeNotKnown<ZWavePlusNodeType>;
    get zwavePlusRoleType(): MaybeNotKnown<ZWavePlusRoleType>;
    get supportsWakeUpOnDemand(): MaybeNotKnown<boolean>;
}
export declare abstract class NodeCapabilityValuesMixin extends NodeValuesMixin implements NodeCapabilityValues {
    get manufacturerId(): MaybeNotKnown<number>;
    get productId(): MaybeNotKnown<number>;
    get productType(): MaybeNotKnown<number>;
    get firmwareVersion(): MaybeNotKnown<string>;
    get hardwareVersion(): MaybeNotKnown<number>;
    get sdkVersion(): MaybeNotKnown<string>;
    get zwavePlusVersion(): MaybeNotKnown<number>;
    get zwavePlusNodeType(): MaybeNotKnown<ZWavePlusNodeType>;
    get zwavePlusRoleType(): MaybeNotKnown<ZWavePlusRoleType>;
    get supportsWakeUpOnDemand(): MaybeNotKnown<boolean>;
}
//# sourceMappingURL=41_CapabilityValues.d.ts.map