import { ManufacturerSpecificCCValues, VersionCCValues, WakeUpCCValues, ZWavePlusCCValues, } from "@zwave-js/cc";
import { NodeValuesMixin } from "./40_Values.js";
export class NodeCapabilityValuesMixin extends NodeValuesMixin {
    get manufacturerId() {
        return this.getValue(ManufacturerSpecificCCValues.manufacturerId.id);
    }
    get productId() {
        return this.getValue(ManufacturerSpecificCCValues.productId.id);
    }
    get productType() {
        return this.getValue(ManufacturerSpecificCCValues.productType.id);
    }
    get firmwareVersion() {
        // On supporting nodes, use the applicationVersion, which MUST be
        // same as the first (main) firmware, plus the patch version.
        const firmware0Version = this.getValue(VersionCCValues.firmwareVersions.id)?.[0];
        const applicationVersion = this.getValue(VersionCCValues.applicationVersion.id);
        let ret = firmware0Version;
        if (applicationVersion) {
            // If the application version is set, we cannot blindly trust that it is the firmware version.
            // Some nodes incorrectly set this field to the Z-Wave Application Framework API Version
            if (!ret || applicationVersion.startsWith(`${ret}.`)) {
                ret = applicationVersion;
            }
        }
        // Special case for the official 700 series firmwares which are aligned with the SDK version
        // We want to work with the full x.y.z firmware version here.
        if (ret && this.isControllerNode) {
            const sdkVersion = this.sdkVersion;
            if (sdkVersion && sdkVersion.startsWith(`${ret}.`)) {
                return sdkVersion;
            }
        }
        // For all others, just return the simple x.y firmware version
        return ret;
    }
    get hardwareVersion() {
        return this.getValue(VersionCCValues.hardwareVersion.id);
    }
    get sdkVersion() {
        return this.getValue(VersionCCValues.sdkVersion.id);
    }
    get zwavePlusVersion() {
        return this.getValue(ZWavePlusCCValues.zwavePlusVersion.id);
    }
    get zwavePlusNodeType() {
        return this.getValue(ZWavePlusCCValues.nodeType.id);
    }
    get zwavePlusRoleType() {
        return this.getValue(ZWavePlusCCValues.roleType.id);
    }
    get supportsWakeUpOnDemand() {
        return this.getValue(WakeUpCCValues.wakeUpOnDemandSupported.id);
    }
}
//# sourceMappingURL=41_CapabilityValues.js.map