import { BinarySwitchCCGet, BinarySwitchCCReport, BinarySwitchCCSet, } from "@zwave-js/cc/BinarySwitchCC";
import { CommandClasses, UNKNOWN_STATE, } from "@zwave-js/core";
const defaultCapabilities = {
    defaultValue: false,
};
const STATE_KEY_PREFIX = "BinarySwitch_";
const StateKeys = {
    currentValue: `${STATE_KEY_PREFIX}currentValue`,
};
const respondToBinarySwitchGet = {
    handleCC(controller, self, receivedCC) {
        if (receivedCC instanceof BinarySwitchCCGet) {
            const capabilities = {
                ...defaultCapabilities,
                ...self.getCCCapabilities(CommandClasses["Binary Switch"], receivedCC.endpointIndex),
            };
            const cc = new BinarySwitchCCReport({
                nodeId: controller.ownNodeId,
                currentValue: (self.state.get(StateKeys.currentValue)
                    ?? capabilities.defaultValue
                    ?? UNKNOWN_STATE),
            });
            return { action: "sendCC", cc };
        }
    },
};
const respondToBinarySwitchSet = {
    handleCC(controller, self, receivedCC) {
        if (receivedCC instanceof BinarySwitchCCSet) {
            self.state.set(StateKeys.currentValue, receivedCC.targetValue);
            return { action: "ok" };
        }
    },
};
export const BinarySwitchCCBehaviors = [
    respondToBinarySwitchGet,
    respondToBinarySwitchSet,
];
//# sourceMappingURL=BinarySwitch.js.map