/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands.parsers;

import de.bluecolored.bluecommands.CommandParseException;
import de.bluecolored.bluecommands.InputReader;
import de.bluecolored.bluecommands.Suggestion;
import de.bluecolored.bluecommands.parsers.SimpleArgumentParser;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class NumberArgumentParser<C, T extends Number>
extends SimpleArgumentParser<C, T> {
    private final Class<T> type;
    private final StringParser<T> numberParser;
    private final double min;
    private final double max;

    private NumberArgumentParser(Class<T> type, StringParser<T> numberParser) {
        super(false, false);
        this.type = type;
        this.numberParser = numberParser;
        this.min = Double.NEGATIVE_INFINITY;
        this.max = Double.POSITIVE_INFINITY;
    }

    private NumberArgumentParser(Class<T> type, StringParser<T> numberParser, double min2, double max) {
        super(false, false);
        this.type = type;
        this.numberParser = numberParser;
        this.min = min2;
        this.max = max;
    }

    @Override
    public T parse(C context, String string) throws CommandParseException {
        Number result = (Number)this.numberParser.parse(string);
        if (result.doubleValue() < this.min) {
            throw new CommandParseException(result + " is too small. It has to be greater or equal to " + this.min);
        }
        if (result.doubleValue() > this.max) {
            throw new CommandParseException(result + " is too big. It has to be smaller or equal to " + this.max);
        }
        return (T)result;
    }

    @Override
    public List<Suggestion> suggest(C context, InputReader input) {
        return Collections.emptyList();
    }

    public Class<T> getType() {
        return this.type;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public NumberArgumentParser<C, T> withBounds(double min2, double max) {
        return new NumberArgumentParser<C, T>(this.type, this.numberParser, min2, max);
    }

    public NumberArgumentParser<C, T> withMin(double min2) {
        return new NumberArgumentParser<C, T>(this.type, this.numberParser, min2, this.max);
    }

    public NumberArgumentParser<C, T> withMax(double max) {
        return new NumberArgumentParser<C, T>(this.type, this.numberParser, this.min, max);
    }

    public static <C> NumberArgumentParser<C, Byte> forBytes() {
        return NumberArgumentParser.createWrapped(Byte.class, Byte::parseByte);
    }

    public static <C> NumberArgumentParser<C, Short> forShorts() {
        return NumberArgumentParser.createWrapped(Short.class, Short::parseShort);
    }

    public static <C> NumberArgumentParser<C, Integer> forIntegers() {
        return NumberArgumentParser.createWrapped(Integer.class, Integer::parseInt);
    }

    public static <C> NumberArgumentParser<C, Long> forLongs() {
        return NumberArgumentParser.createWrapped(Long.class, Long::parseLong);
    }

    public static <C> NumberArgumentParser<C, Float> forFloats() {
        return NumberArgumentParser.createWrapped(Float.class, Float::parseFloat);
    }

    public static <C> NumberArgumentParser<C, Double> forDoubles() {
        return NumberArgumentParser.createWrapped(Double.class, Double::parseDouble);
    }

    private static <C, T extends Number> NumberArgumentParser<C, T> createWrapped(Class<T> type, Function<String, T> numberParser) {
        return new NumberArgumentParser<C, T>(type, NumberArgumentParser.wrap(numberParser, type));
    }

    private static <T> StringParser<T> wrap(Function<String, T> numberParser, Class<T> type) {
        return s2 -> {
            try {
                return numberParser.apply(s2);
            }
            catch (RuntimeException ex) {
                throw new CommandParseException("'" + s2 + "' is not a vaild " + type.getSimpleName());
            }
        };
    }

    private static interface StringParser<T> {
        public T parse(String var1) throws CommandParseException;
    }
}

