/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.gson;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.HtmlMarker;
import de.bluecolored.bluemap.api.markers.LineMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.POIMarker;
import de.bluecolored.bluemap.api.markers.ShapeMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Line;
import de.bluecolored.bluemap.api.math.Shape;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.Map;

public final class MarkerGson {
    public static final Gson INSTANCE = MarkerGson.addAdapters(new GsonBuilder()).setLenient().create();

    private MarkerGson() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static GsonBuilder addAdapters(GsonBuilder builder) {
        return builder.registerTypeAdapter((Type)((Object)Marker.class), new MarkerDeserializer()).registerTypeAdapter((Type)((Object)Marker.class), new MarkerSerializer()).registerTypeAdapter((Type)((Object)Line.class), new LineAdapter()).registerTypeAdapter((Type)((Object)Shape.class), new ShapeAdapter()).registerTypeAdapter((Type)((Object)Color.class), new ColorAdapter()).registerTypeAdapter((Type)((Object)Vector2d.class), new Vector2dAdapter()).registerTypeAdapter((Type)((Object)Vector3d.class), new Vector3dAdapter()).registerTypeAdapter((Type)((Object)Vector2i.class), new Vector2iAdapter()).registerTypeAdapter((Type)((Object)Vector3i.class), new Vector3iAdapter());
    }

    static class MarkerDeserializer
    implements JsonDeserializer<Marker> {
        private static final Map<String, Class<? extends Marker>> MARKER_TYPES = Map.of("html", HtmlMarker.class, "poi", POIMarker.class, "shape", ShapeMarker.class, "extrude", ExtrudeMarker.class, "line", LineMarker.class);

        MarkerDeserializer() {
        }

        @Override
        public Marker deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            String markerType = jsonElement.getAsJsonObject().get("type").getAsString();
            Class<? extends Marker> markerClass = MARKER_TYPES.get(markerType);
            if (markerClass == null) {
                throw new JsonParseException("Unknown marker type: " + markerType);
            }
            return (Marker)context.deserialize(jsonElement, markerClass);
        }
    }

    static class MarkerSerializer
    implements JsonSerializer<Marker> {
        MarkerSerializer() {
        }

        @Override
        public JsonElement serialize(Marker src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(src, src.getClass());
        }
    }

    static class LineAdapter
    extends TypeAdapter<Line> {
        private static final Vector3dAdapter VEC3D_ADAPTER = new Vector3dAdapter();

        LineAdapter() {
        }

        @Override
        public void write(JsonWriter out, Line value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (Vector3d point : value.getPoints()) {
                VEC3D_ADAPTER.write(out, point);
            }
            out.endArray();
        }

        @Override
        public Line read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            LinkedList<Vector3d> points = new LinkedList<Vector3d>();
            in.beginArray();
            while (in.peek() != JsonToken.END_ARRAY) {
                Vector3d point = VEC3D_ADAPTER.read(in);
                if (point == null) continue;
                points.add(point);
            }
            in.endArray();
            return new Line((Vector3d[])points.toArray(Vector3d[]::new));
        }
    }

    static class ShapeAdapter
    extends TypeAdapter<Shape> {
        private static final Vector2dAdapter VEC2D_ADAPTER = new Vector2dAdapter(true);

        ShapeAdapter() {
        }

        @Override
        public void write(JsonWriter out, Shape value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (Vector2d point : value.getPoints()) {
                VEC2D_ADAPTER.write(out, point);
            }
            out.endArray();
        }

        @Override
        public Shape read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            LinkedList<Vector2d> points = new LinkedList<Vector2d>();
            in.beginArray();
            while (in.peek() != JsonToken.END_ARRAY) {
                Vector2d point = VEC2D_ADAPTER.read(in);
                if (point == null) continue;
                points.add(point);
            }
            in.endArray();
            return new Shape((Vector2d[])points.toArray(Vector2d[]::new));
        }
    }

    static class ColorAdapter
    extends TypeAdapter<Color> {
        ColorAdapter() {
        }

        @Override
        public void write(JsonWriter out, Color value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("r");
            out.value(value.getRed());
            out.name("g");
            out.value(value.getGreen());
            out.name("b");
            out.value(value.getBlue());
            out.name("a");
            out.value(value.getAlpha());
            out.endObject();
        }

        @Override
        public Color read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            int r = 0;
            int g2 = 0;
            int b = 0;
            float a = 1.0f;
            block12: while (in.peek() != JsonToken.END_OBJECT) {
                switch (in.nextName()) {
                    case "r": {
                        r = in.nextInt();
                        continue block12;
                    }
                    case "g": {
                        g2 = in.nextInt();
                        continue block12;
                    }
                    case "b": {
                        b = in.nextInt();
                        continue block12;
                    }
                    case "a": {
                        a = (float)in.nextDouble();
                        continue block12;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Color(r, g2, b, a);
        }
    }

    static class Vector2dAdapter
    extends TypeAdapter<Vector2d> {
        private final boolean useZ;

        public Vector2dAdapter() {
            this.useZ = false;
        }

        public Vector2dAdapter(boolean useZ) {
            this.useZ = useZ;
        }

        @Override
        public void write(JsonWriter out, Vector2d value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("x");
            this.writeRounded(out, value.getX());
            out.name(this.useZ ? "z" : "y");
            this.writeRounded(out, value.getY());
            out.endObject();
        }

        @Override
        public Vector2d read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            double x = 0.0;
            double y = 0.0;
            block10: while (in.peek() != JsonToken.END_OBJECT) {
                switch (in.nextName()) {
                    case "x": {
                        x = in.nextDouble();
                        continue block10;
                    }
                    case "y": {
                        if (!this.useZ) {
                            y = in.nextDouble();
                            continue block10;
                        }
                        in.skipValue();
                        continue block10;
                    }
                    case "z": {
                        if (this.useZ) {
                            y = in.nextDouble();
                            continue block10;
                        }
                        in.skipValue();
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Vector2d(x, y);
        }

        private void writeRounded(JsonWriter json, double value) throws IOException {
            double d = (double)Math.round(value * 10000.0) / 10000.0;
            if (d == (double)((long)d)) {
                json.value((long)d);
            } else {
                json.value(d);
            }
        }
    }

    static class Vector3dAdapter
    extends TypeAdapter<Vector3d> {
        Vector3dAdapter() {
        }

        @Override
        public void write(JsonWriter out, Vector3d value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("x");
            this.writeRounded(out, value.getX());
            out.name("y");
            this.writeRounded(out, value.getY());
            out.name("z");
            this.writeRounded(out, value.getZ());
            out.endObject();
        }

        @Override
        public Vector3d read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            block10: while (in.peek() != JsonToken.END_OBJECT) {
                switch (in.nextName()) {
                    case "x": {
                        x = in.nextDouble();
                        continue block10;
                    }
                    case "y": {
                        y = in.nextDouble();
                        continue block10;
                    }
                    case "z": {
                        z = in.nextDouble();
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Vector3d(x, y, z);
        }

        private void writeRounded(JsonWriter json, double value) throws IOException {
            double d = (double)Math.round(value * 10000.0) / 10000.0;
            if (d == (double)((long)d)) {
                json.value((long)d);
            } else {
                json.value(d);
            }
        }
    }

    static class Vector2iAdapter
    extends TypeAdapter<Vector2i> {
        Vector2iAdapter() {
        }

        @Override
        public void write(JsonWriter out, Vector2i value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("x");
            out.value(value.getX());
            out.name("y");
            out.value(value.getY());
            out.endObject();
        }

        @Override
        public Vector2i read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            int x = 0;
            int y = 0;
            block8: while (in.peek() != JsonToken.END_OBJECT) {
                switch (in.nextName()) {
                    case "x": {
                        x = in.nextInt();
                        continue block8;
                    }
                    case "y": {
                        y = in.nextInt();
                        continue block8;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Vector2i(x, y);
        }
    }

    static class Vector3iAdapter
    extends TypeAdapter<Vector3i> {
        Vector3iAdapter() {
        }

        @Override
        public void write(JsonWriter out, Vector3i value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("x");
            out.value(value.getX());
            out.name("y");
            out.value(value.getY());
            out.name("z");
            out.value(value.getZ());
            out.endObject();
        }

        @Override
        public Vector3i read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            int x = 0;
            int y = 0;
            int z = 0;
            block10: while (in.peek() != JsonToken.END_OBJECT) {
                switch (in.nextName()) {
                    case "x": {
                        x = in.nextInt();
                        continue block10;
                    }
                    case "y": {
                        y = in.nextInt();
                        continue block10;
                    }
                    case "z": {
                        z = in.nextInt();
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Vector3i(x, y, z);
        }
    }
}

