/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.markers;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.markers.ObjectMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class ExtrudeMarker
extends ObjectMarker {
    private static final Shape DEFAULT_SHAPE = Shape.createRect(0.0, 0.0, 1.0, 1.0);
    private Shape shape;
    private Collection<Shape> holes = new ArrayList<Shape>();
    private float shapeMinY;
    private float shapeMaxY;
    private boolean depthTest = true;
    private int lineWidth = 2;
    private Color lineColor = new Color(255, 0, 0, 1.0f);
    private Color fillColor = new Color(200, 0, 0, 0.3f);

    private ExtrudeMarker() {
        this("", DEFAULT_SHAPE, 0.0f, 0.0f);
    }

    public ExtrudeMarker(String label, Shape shape, float shapeMinY, float shapeMaxY) {
        this(label, ExtrudeMarker.calculateShapeCenter(Objects.requireNonNull(shape, "shape must not be null"), shapeMinY, shapeMaxY), shape, shapeMinY, shapeMaxY);
    }

    public ExtrudeMarker(String label, Vector3d position, Shape shape, float shapeMinY, float shapeMaxY) {
        super("extrude", label, position);
        this.shape = Objects.requireNonNull(shape, "shape must not be null");
        this.shapeMinY = shapeMinY;
        this.shapeMaxY = shapeMaxY;
    }

    public Shape getShape() {
        return this.shape;
    }

    public float getShapeMinY() {
        return this.shapeMinY;
    }

    public float getShapeMaxY() {
        return this.shapeMaxY;
    }

    public void setShape(Shape shape, float minY, float maxY) {
        this.shape = Objects.requireNonNull(shape, "shape must not be null");
        this.shapeMinY = minY;
        this.shapeMaxY = maxY;
    }

    public Collection<Shape> getHoles() {
        return this.holes;
    }

    public void centerPosition() {
        this.setPosition(ExtrudeMarker.calculateShapeCenter(this.shape, this.shapeMinY, this.shapeMaxY));
    }

    public boolean isDepthTestEnabled() {
        return this.depthTest;
    }

    public void setDepthTestEnabled(boolean enabled) {
        this.depthTest = enabled;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = Objects.requireNonNull(color, "color must not be null");
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = Objects.requireNonNull(color, "color must not be null");
    }

    public void setColors(Color lineColor, Color fillColor) {
        this.setLineColor(lineColor);
        this.setFillColor(fillColor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtrudeMarker that = (ExtrudeMarker)o;
        if (Float.compare(that.shapeMinY, this.shapeMinY) != 0) {
            return false;
        }
        if (Float.compare(that.shapeMaxY, this.shapeMaxY) != 0) {
            return false;
        }
        if (this.depthTest != that.depthTest) {
            return false;
        }
        if (this.lineWidth != that.lineWidth) {
            return false;
        }
        if (!this.shape.equals(that.shape)) {
            return false;
        }
        if (!this.lineColor.equals(that.lineColor)) {
            return false;
        }
        return this.fillColor.equals(that.fillColor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.shape.hashCode();
        result = 31 * result + (this.shapeMinY != 0.0f ? Float.floatToIntBits(this.shapeMinY) : 0);
        result = 31 * result + (this.shapeMaxY != 0.0f ? Float.floatToIntBits(this.shapeMaxY) : 0);
        result = 31 * result + (this.depthTest ? 1 : 0);
        result = 31 * result + this.lineWidth;
        result = 31 * result + this.lineColor.hashCode();
        result = 31 * result + this.fillColor.hashCode();
        return result;
    }

    private static Vector3d calculateShapeCenter(Shape shape, float shapeMinY, float shapeMaxY) {
        Vector2d center = shape.getMin().add(shape.getMax()).mul(0.5);
        float centerY = (shapeMinY + shapeMaxY) * 0.5f;
        return new Vector3d(center.getX(), (double)centerY, center.getY());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ObjectMarker.Builder<ExtrudeMarker, Builder> {
        Shape shape;
        float shapeMinY;
        float shapeMaxY;
        Collection<Shape> holes = new ArrayList<Shape>();
        Boolean depthTest;
        Integer lineWidth;
        Color lineColor;
        Color fillColor;

        public Builder shape(Shape shape, float minY, float maxY) {
            this.shape = shape;
            this.shapeMinY = minY;
            this.shapeMaxY = maxY;
            return this;
        }

        public Builder holes(Shape ... holes) {
            this.holes.addAll(Arrays.asList(holes));
            return this;
        }

        public Builder clearHoles() {
            this.holes.clear();
            return this;
        }

        public Builder centerPosition() {
            this.position(null);
            return this;
        }

        public Builder depthTestEnabled(boolean enabled) {
            this.depthTest = enabled;
            return this;
        }

        public Builder lineWidth(int width) {
            this.lineWidth = width;
            return this;
        }

        public Builder lineColor(Color color) {
            this.lineColor = color;
            return this;
        }

        public Builder fillColor(Color color) {
            this.fillColor = color;
            return this;
        }

        @Override
        public ExtrudeMarker build() {
            ExtrudeMarker marker = new ExtrudeMarker(this.checkNotNull(this.label, "label"), this.checkNotNull(this.shape, "shape"), this.shapeMinY, this.shapeMaxY);
            marker.getHoles().addAll(this.holes);
            if (this.depthTest != null) {
                marker.setDepthTestEnabled(this.depthTest);
            }
            if (this.lineWidth != null) {
                marker.setLineWidth(this.lineWidth);
            }
            if (this.lineColor != null) {
                marker.setLineColor(this.lineColor);
            }
            if (this.fillColor != null) {
                marker.setFillColor(this.fillColor);
            }
            return this.build(marker);
        }
    }
}

