/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.checks;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.common.BlueMapConfiguration;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.checks.Check;
import de.bluecolored.bluemap.common.commands.checks.CheckResult;
import de.bluecolored.bluemap.common.config.BlueMapConfigManager;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.core.map.BmMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.StyleSetter;

public class TileInsideBoundsCheck
implements Check {
    private final Plugin plugin;
    private final BmMap map;
    private final Vector2i position;

    @Override
    public CheckResult getResult() {
        return this.map.getMapSettings().isInsideRenderBoundaries(this.position.getX(), this.position.getY()) ? CheckResult.OK : CheckResult.BAD;
    }

    @Override
    public Component getFailureDescription() {
        return TextFormat.lines(TextFormat.format("\u26a0 this position is outside the boundaries of map %", TextFormat.formatMap(this.map).color(TextFormat.HIGHLIGHT_COLOR)), Component.empty(), TextFormat.format("make sure to set %, %, % and %\nin % correctly\n".strip(), Component.text("min-x").color(TextFormat.HIGHLIGHT_COLOR), Component.text("min-z").color(TextFormat.HIGHLIGHT_COLOR), Component.text("max-x").color(TextFormat.HIGHLIGHT_COLOR), Component.text("max-z").color(TextFormat.HIGHLIGHT_COLOR), this.formatConfigFilePath("maps/" + this.map.getId()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
    }

    private Component formatConfigFilePath(String name) {
        StyleSetter<Component> format = Component.text(name + ".conf");
        BlueMapConfiguration blueMapConfiguration = this.plugin.getBlueMap().getConfig();
        if (blueMapConfiguration instanceof BlueMapConfigManager) {
            BlueMapConfigManager configManager = (BlueMapConfigManager)blueMapConfiguration;
            format = format.hoverEvent((HoverEventSource)Component.text(BlueMapConfigManager.formatPath(configManager.getConfigManager().resolveConfigFile(name))));
        }
        return format;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public BmMap getMap() {
        return this.map;
    }

    public Vector2i getPosition() {
        return this.position;
    }

    public TileInsideBoundsCheck(Plugin plugin, BmMap map, Vector2i position) {
        this.plugin = plugin;
        this.map = map;
        this.position = position;
    }
}

