/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.checks;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.checks.Check;
import de.bluecolored.bluemap.common.commands.checks.CheckResult;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.map.renderstate.TileInfoRegion;
import de.bluecolored.bluemap.core.map.renderstate.TileState;
import java.time.Instant;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;

public class TileNoChunkErrorCheck
implements Check {
    private final BmMap map;
    private final Vector2i position;
    private final Vector2i tile;
    private final TileInfoRegion.TileInfo tileInfo;

    public TileNoChunkErrorCheck(BmMap map, Vector2i position) {
        this.map = map;
        this.position = position;
        this.tile = map.getHiresModelManager().getTileGrid().getCell(position);
        this.tileInfo = map.getMapTileState().get(this.tile.getX(), this.tile.getY());
    }

    @Override
    public CheckResult getResult() {
        return this.tileInfo.getState() != TileState.CHUNK_ERROR ? CheckResult.OK : CheckResult.BAD;
    }

    @Override
    public Component getFailureDescription() {
        return TextFormat.lines(TextFormat.format("\u26a0 there was an error while loading a chunk\naround (x:%, z:%) for map %\n".strip(), Component.text(this.position.getX()).color(TextFormat.HIGHLIGHT_COLOR), Component.text(this.position.getY()).color(TextFormat.HIGHLIGHT_COLOR), TextFormat.formatMap(this.map).color(TextFormat.HIGHLIGHT_COLOR)), Component.empty(), TextFormat.format("make sure your world is fully upgraded to your current\nminecraft-version and try loading this region in-game\nwith a player\n\nif the problem persists, you can visit bluemaps % for help\n\nthe last time bluemap tried to render this region\nwas % ago\n".strip(), ((TextComponent)((TextComponent)Component.text("discord").hoverEvent((HoverEventSource)Component.text("https://discord.gg/zmkyJa3"))).clickEvent(ClickEvent.openUrl("https://discord.gg/zmkyJa3"))).color(TextFormat.HIGHLIGHT_COLOR), TextFormat.durationFormat(Instant.ofEpochSecond(this.tileInfo.getRenderTime()))).color(TextFormat.BASE_COLOR));
    }

    public BmMap getMap() {
        return this.map;
    }

    public Vector2i getPosition() {
        return this.position;
    }

    public Vector2i getTile() {
        return this.tile;
    }

    public TileInfoRegion.TileInfo getTileInfo() {
        return this.tileInfo;
    }

    public TileNoChunkErrorCheck(BmMap map, Vector2i position, Vector2i tile, TileInfoRegion.TileInfo tileInfo) {
        this.map = map;
        this.position = position;
        this.tile = tile;
        this.tileInfo = tileInfo;
    }
}

