/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.commands;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluecommands.annotations.Argument;
import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluemap.common.BlueMapService;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.Unloaded;
import de.bluecolored.bluemap.common.commands.WithPosition;
import de.bluecolored.bluemap.common.commands.WithWorld;
import de.bluecolored.bluemap.common.config.BlueMapConfigManager;
import de.bluecolored.bluemap.common.debug.StateDumper;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.map.renderstate.TileInfoRegion;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.ChunkConsumer;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.mca.chunk.MCAChunk;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;

@Command(value={"debug"})
public class DebugCommand {
    private final Plugin plugin;

    @Command(value={"dump"})
    @Permission(value="bluemap.debug.dump")
    @Unloaded
    public int dump(CommandSource source) {
        try {
            BlueMapService bluemap = this.plugin.getBlueMap();
            Path file = bluemap != null ? bluemap.getConfig().getCoreConfig().getData().resolve("dump.json") : Path.of("dump.json", new String[0]);
            StateDumper.global().dump(file);
            source.sendMessage(TextFormat.format("Dump \ud83d\udca9 created at: %", Component.text(BlueMapConfigManager.formatPath(file)).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.POSITIVE_COLOR));
            return 1;
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to create dump!", ex);
            source.sendMessage(Component.text("Exception trying to create debug-dump! See console for details.").color(TextFormat.NEGATIVE_COLOR));
            return 0;
        }
    }

    @Command(value={"world"})
    @Permission(value="bluemap.debug.world")
    @WithWorld
    @WithPosition
    public Component block(CommandSource source, World world, Vector3d position) {
        return this.block(source, world, position.getFloorX(), (int)Math.floor(position.getY() - 0.1), position.getFloorZ());
    }

    @Command(value={"world <map> <x> <y> <z>"})
    @Permission(value="bluemap.debug.world")
    public Component block(CommandSource source, @Argument(value="map") BmMap map, @Argument(value="x") int x, @Argument(value="y") int y, @Argument(value="z") int z) {
        return this.block(source, map.getWorld(), x, y, z);
    }

    @Command(value={"world <x> <y> <z>"})
    @Permission(value="bluemap.debug.world")
    @WithWorld
    public Component block(CommandSource source, World world, @Argument(value="x") int x, @Argument(value="y") int y, @Argument(value="z") int z) {
        Component component;
        Vector2i chunkPos = world.getChunkGrid().getCell(new Vector2i(x, z));
        Chunk chunk = world.getChunkAtBlock(x, z);
        LightData lightData = chunk.getLightData(x, y, z, new LightData(0, 0));
        Vector3i spawnPoint = world.getSpawnPoint();
        Component[] componentArray = new Component[4];
        componentArray[0] = TextFormat.item("position", TextFormat.format("( x: % | y: % | z: % )", Component.text(x).color(TextFormat.HIGHLIGHT_COLOR), Component.text(y).color(TextFormat.HIGHLIGHT_COLOR), Component.text(z).color(TextFormat.HIGHLIGHT_COLOR)));
        componentArray[1] = TextFormat.item("block", ((TextComponent)((TextComponent)Component.text(chunk.getBlockState(x, y, z).toString()).color(TextFormat.HIGHLIGHT_COLOR)).appendNewline()).append(TextFormat.details(TextFormat.BASE_COLOR, TextFormat.item("biome", chunk.getBiome(x, y, z).getKey().getFormatted()), TextFormat.item("block-light", lightData.getBlockLight()), TextFormat.item("sky-light", lightData.getSkyLight()))));
        Component component2 = TextFormat.format("( x: % | z: % )", Component.text(chunkPos.getX()).color(TextFormat.HIGHLIGHT_COLOR), Component.text(chunkPos.getY()).color(TextFormat.HIGHLIGHT_COLOR)).appendNewline();
        Component[] componentArray2 = new Component[4];
        componentArray2[0] = TextFormat.item("is generated", chunk.isGenerated());
        componentArray2[1] = TextFormat.item("has lightdata", chunk.hasLightData());
        if (chunk instanceof MCAChunk) {
            MCAChunk mcaChunk = (MCAChunk)chunk;
            component = TextFormat.item("data-version", mcaChunk.getDataVersion());
        } else {
            component = null;
        }
        componentArray2[2] = component;
        componentArray2[3] = TextFormat.item("inhabited-time", chunk.getInhabitedTime());
        componentArray[2] = TextFormat.item("chunk", component2.append(TextFormat.details(TextFormat.BASE_COLOR, TextFormat.stripNulls(componentArray2))));
        componentArray[3] = TextFormat.item("world", ((TextComponent)((TextComponent)Component.text(world.getId()).color(TextFormat.HIGHLIGHT_COLOR)).appendNewline()).append(TextFormat.details(TextFormat.BASE_COLOR, TextFormat.item("name", world.getName()), TextFormat.item("min-y", world.getDimensionType().getMinY()), TextFormat.item("height", world.getDimensionType().getHeight()), TextFormat.item("spawn", TextFormat.format("( x: % | y: % | z: % )", Component.text(spawnPoint.getX()).color(TextFormat.HIGHLIGHT_COLOR), Component.text(spawnPoint.getY()).color(TextFormat.HIGHLIGHT_COLOR), Component.text(spawnPoint.getZ()).color(TextFormat.HIGHLIGHT_COLOR))))));
        return TextFormat.paragraph("World-Info (debug)", TextFormat.lines(componentArray));
    }

    @Command(value={"map"})
    @Permission(value="bluemap.debug.map")
    @WithWorld
    @WithPosition
    public Component map(CommandSource source, World world, Vector3d position) {
        return this.map(source, world, position.getFloorX(), position.getFloorZ());
    }

    @Command(value={"map <map>"})
    @Permission(value="bluemap.debug.map")
    @WithWorld
    @WithPosition
    public Component map(CommandSource source, @Argument(value="map") BmMap map, World world, Vector3d position) {
        if (!map.getWorld().getId().equals(world.getId())) {
            return TextFormat.format("Map % is not from your current world", TextFormat.formatMap(map)).color(TextFormat.NEGATIVE_COLOR);
        }
        return this.map(source, map, position.getFloorX(), position.getFloorZ());
    }

    @Command(value={"map <x> <z>"})
    @Permission(value="bluemap.debug.map")
    @WithWorld
    public Component map(CommandSource source, World world, @Argument(value="x") int x, @Argument(value="z") int z) {
        BmMap map = this.plugin.getBlueMap().getMaps().values().stream().filter(m4 -> m4.getWorld().getId().equals(world.getId())).findAny().orElse(null);
        if (map == null) {
            return Component.text("No map found for your world").color(TextFormat.NEGATIVE_COLOR);
        }
        return this.map(source, map, x, z);
    }

    @Command(value={"map <map> <x> <z>"})
    @Permission(value="bluemap.debug.map")
    public Component map(CommandSource source, @Argument(value="map") BmMap map, @Argument(value="x") int x, @Argument(value="z") int z) {
        Vector2i blockPos = new Vector2i(x, z);
        final Vector2i chunkPos = map.getWorld().getChunkGrid().getCell(blockPos);
        Vector2i regionPos = map.getWorld().getRegionGrid().getCell(blockPos);
        Vector2i tilePos = map.getHiresModelManager().getTileGrid().getCell(blockPos);
        TileInfoRegion.TileInfo tileInfo = map.getMapTileState().get(tilePos.getX(), tilePos.getY());
        int tileRenderTime = tileInfo.getRenderTime();
        int lastChunkHash = map.getMapChunkState().get(chunkPos.getX(), chunkPos.getY());
        int currentChunkHash = 0;
        try {
            class FindHashConsumer
            implements ChunkConsumer.ListOnly<Chunk> {
                public int timestamp = 0;

                FindHashConsumer() {
                }

                @Override
                public void accept(int chunkX, int chunkZ, int timestamp) {
                    if (chunkPos.getX() == chunkX && chunkPos.getY() == chunkZ) {
                        this.timestamp = timestamp;
                    }
                }
            }
            FindHashConsumer findHashConsumer = new FindHashConsumer();
            map.getWorld().getRegion(regionPos.getX(), regionPos.getY()).iterateAllChunks(findHashConsumer);
            currentChunkHash = findHashConsumer.timestamp;
        }
        catch (IOException e) {
            Logger.global.logError("Failed to load chunk-hash.", e);
        }
        return TextFormat.paragraph("Map-Info (debug)", TextFormat.lines(TextFormat.item("position", TextFormat.format("( x: % | z: % )", Component.text(x).color(TextFormat.HIGHLIGHT_COLOR), Component.text(z).color(TextFormat.HIGHLIGHT_COLOR))), TextFormat.item("chunk", TextFormat.format("( x: % | z: % )", Component.text(chunkPos.getX()).color(TextFormat.HIGHLIGHT_COLOR), Component.text(chunkPos.getY()).color(TextFormat.HIGHLIGHT_COLOR)).appendNewline().append(TextFormat.details(TextFormat.BASE_COLOR, TextFormat.item("current hash", currentChunkHash), TextFormat.item("last rendered", lastChunkHash)))), TextFormat.item("tile", TextFormat.format("( x: % | z: % )", Component.text(tilePos.getX()).color(TextFormat.HIGHLIGHT_COLOR), Component.text(tilePos.getY()).color(TextFormat.HIGHLIGHT_COLOR)).appendNewline().append(TextFormat.details(TextFormat.BASE_COLOR, TextFormat.stripNulls(tileRenderTime > 0 ? TextFormat.item("rendered", TextFormat.durationFormat(Instant.ofEpochSecond(tileRenderTime))).append(Component.text(" ago")) : null, TextFormat.item("state", tileInfo.getState().getKey().getFormatted())))))));
    }

    public DebugCommand(Plugin plugin) {
        this.plugin = plugin;
    }
}

