/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.commands;

import de.bluecolored.bluecommands.annotations.Argument;
import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.MapRenderTask;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.core.map.BmMap;
import net.kyori.adventure.text.Component;

public class FreezeCommand {
    private final Plugin plugin;

    @Command(value={"freeze <map>"})
    @Permission(value="bluemap.freeze")
    public void freeze(CommandSource source, @Argument(value="map") BmMap map) {
        this.plugin.getPluginState().getMapState(map).setUpdateEnabled(false);
        this.plugin.stopWatchingMap(map);
        this.plugin.getRenderManager().removeRenderTasksIf(task -> {
            MapRenderTask mrt;
            return task instanceof MapRenderTask && (mrt = (MapRenderTask)task).getMap().equals(map);
        });
        source.sendMessage(TextFormat.format("% Map % is now % and will no longer automatically update\nAny currently scheduled updates for this map have been cancelled\n".strip(), TextFormat.ICON_FROZEN, TextFormat.formatMap(map).color(TextFormat.HIGHLIGHT_COLOR), Component.text("frozen").color(TextFormat.FROZEN_COLOR)).color(TextFormat.BASE_COLOR));
        this.plugin.save();
    }

    public FreezeCommand(Plugin plugin) {
        this.plugin = plugin;
    }
}

