/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.commands;

import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.MapPurgeTask;
import de.bluecolored.bluemap.common.rendermanager.MapRenderTask;
import de.bluecolored.bluemap.common.rendermanager.MapUpdateTask;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.map.BmMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;

public class MapListCommand {
    private final Plugin plugin;

    @Command(value={"maps"})
    @Permission(value="bluemap.maps")
    public Component mapList() {
        Map<String, BmMap> maps = this.plugin.getBlueMap().getMaps();
        List<Component> entries = maps.values().stream().sorted(Comparator.comparing(map -> map.getMapSettings().getSorting())).map(this::element).toList();
        return TextFormat.paragraph("Maps", TextFormat.lines(entries));
    }

    private Component element(BmMap map) {
        MapRenderTask mapTask;
        RenderTask task2;
        long pendingCount;
        Component icon = TextFormat.ICON_UPDATED;
        LinkedList<Component> details = new LinkedList<Component>();
        if (!this.plugin.getPluginState().getMapState(map).isUpdateEnabled()) {
            icon = TextFormat.ICON_FROZEN;
            details.addFirst(TextFormat.format("is %", Component.text("frozen").color(TextFormat.HIGHLIGHT_COLOR)));
        }
        if ((pendingCount = this.plugin.getRenderManager().getScheduledRenderTasks().stream().skip(1L).filter(task -> {
            MapRenderTask mapTask;
            return task instanceof MapRenderTask && (mapTask = (MapRenderTask)task).getMap().equals(map);
        }).count()) > 0L) {
            icon = TextFormat.ICON_PENDING;
            details.addFirst(TextFormat.format(pendingCount == 1L ? "has % pending task" : "has % pending tasks", Component.text(pendingCount).color(TextFormat.HIGHLIGHT_COLOR)));
        }
        if ((task2 = this.plugin.getRenderManager().getCurrentRenderTask()) instanceof MapRenderTask && (mapTask = (MapRenderTask)task2).getMap().equals(map)) {
            icon = TextFormat.ICON_IN_PROGRESS;
            RenderTask renderTask = task2;
            Objects.requireNonNull(renderTask);
            RenderTask renderTask2 = renderTask;
            int n = 0;
            String format = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MapUpdateTask.class, WorldRegionRenderTask.class, MapPurgeTask.class}, (Object)renderTask2, n)) {
                case 0 -> {
                    MapUpdateTask ignored = (MapUpdateTask)renderTask2;
                    yield "is currently being updated: %";
                }
                case 1 -> {
                    WorldRegionRenderTask ignored = (WorldRegionRenderTask)renderTask2;
                    yield "is currently being updated: %";
                }
                case 2 -> {
                    MapPurgeTask ignored = (MapPurgeTask)renderTask2;
                    yield "is currently being purged: %";
                }
                default -> "has a running task: %";
            };
            details.addFirst((Component)TextFormat.format(format, Component.text(String.format("%.3f%%", task2.estimateProgress() * 100.0)).color(TextFormat.HIGHLIGHT_COLOR)).hoverEvent(HoverEvent.showText(Component.text(task2.getDescription()))));
        }
        return TextFormat.lines(icon.appendSpace().append(TextFormat.formatMap(map).color(TextFormat.HIGHLIGHT_COLOR)), details.isEmpty() ? null : TextFormat.details(TextFormat.BASE_COLOR, details));
    }

    public MapListCommand(Plugin plugin) {
        this.plugin = plugin;
    }
}

