/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;

@ConfigSerializable
public class WebserverConfig {
    private boolean enabled = true;
    private Path webroot = Path.of("bluemap", "web");
    private String ip = "0.0.0.0";
    private int port = 8100;
    private LogConfig log = new LogConfig();

    public boolean isEnabled() {
        return this.enabled;
    }

    public Path getWebroot() {
        return this.webroot;
    }

    public String getIp() {
        return this.ip;
    }

    public InetAddress resolveIp() throws UnknownHostException {
        if (this.ip.isEmpty() || this.ip.equals("0.0.0.0") || this.ip.equals("::0")) {
            return new InetSocketAddress(0).getAddress();
        }
        if (this.ip.equals("#getLocalHost")) {
            return InetAddress.getLocalHost();
        }
        return InetAddress.getByName(this.ip);
    }

    public int getPort() {
        return this.port;
    }

    public LogConfig getLog() {
        return this.log;
    }

    @ConfigSerializable
    public static class LogConfig {
        private String file = null;
        private boolean append = false;
        private String format = "%1$s \"%3$s %4$s %5$s\" %6$s %7$s";

        public String getFile() {
            return this.file;
        }

        public boolean isAppend() {
            return this.append;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

