/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.mask;

import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.bluemap.api.math.Shape;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.mask.MaskConfig;
import de.bluecolored.bluemap.core.map.mask.Mask;
import de.bluecolored.bluemap.core.map.mask.PolygonMask;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;

@ConfigSerializable
public class PolygonMaskConfig
extends MaskConfig {
    private int minY = Integer.MIN_VALUE;
    private int maxY = Integer.MAX_VALUE;
    private Vector2d[] shape;

    @Override
    public Mask createMask() throws ConfigurationException {
        if (this.minY > this.maxY) {
            throw new ConfigurationException("The polygon-mask configuration results in a degenerate mask.\nMake sure that the \"min-y\" value is actually SMALLER than the \"max-y\" counterpart.\n".trim());
        }
        if (this.shape == null || this.shape.length < 3) {
            throw new ConfigurationException("The polygon-mask configuration needs at least 3 points for a valid shape.\n".trim());
        }
        return new PolygonMask(new Shape(this.shape), this.minY, this.maxY);
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public Vector2d[] getShape() {
        return this.shape;
    }
}

