/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.storage;

import de.bluecolored.bluemap.core.storage.sql.Database;
import de.bluecolored.bluemap.core.storage.sql.commandset.CommandSet;
import de.bluecolored.bluemap.core.storage.sql.commandset.MySQLCommandSet;
import de.bluecolored.bluemap.core.storage.sql.commandset.PostgreSQLCommandSet;
import de.bluecolored.bluemap.core.storage.sql.commandset.SqliteCommandSet;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;
import java.util.function.Function;

public interface Dialect
extends Keyed {
    public static final Dialect MYSQL = new Impl(Key.bluemap("mysql"), "jdbc:mysql:", MySQLCommandSet::new);
    public static final Dialect MARIADB = new Impl(Key.bluemap("mariadb"), "jdbc:mariadb:", MySQLCommandSet::new);
    public static final Dialect POSTGRESQL = new Impl(Key.bluemap("postgresql"), "jdbc:postgresql:", PostgreSQLCommandSet::new);
    public static final Dialect SQLITE = new Impl(Key.bluemap("sqlite"), "jdbc:sqlite:", SqliteCommandSet::new);
    public static final Registry<Dialect> REGISTRY = new Registry((Keyed[])new Dialect[]{MYSQL, MARIADB, POSTGRESQL, SQLITE});

    public boolean supports(String var1);

    public CommandSet createCommandSet(Database var1);

    public static class Impl
    implements Dialect {
        private final Key key;
        private final String protocol;
        private final Function<Database, CommandSet> commandSetProvider;

        @Override
        public boolean supports(String connectionUrl) {
            return connectionUrl.startsWith(this.protocol);
        }

        @Override
        public CommandSet createCommandSet(Database database) {
            return this.commandSetProvider.apply(database);
        }

        public Impl(Key key, String protocol, Function<Database, CommandSet> commandSetProvider) {
            this.key = key;
            this.protocol = protocol;
            this.commandSetProvider = commandSetProvider;
        }

        @Override
        public Key getKey() {
            return this.key;
        }
    }
}

