/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.storage;

import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.storage.StorageType;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;
import java.util.Locale;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;

@ConfigSerializable
public abstract class StorageConfig {
    private String storageType = StorageType.FILE.getKey().getFormatted();

    public StorageType getStorageType() throws ConfigurationException {
        return StorageConfig.parseKey(StorageType.REGISTRY, this.storageType, "storage-type");
    }

    public abstract Storage createStorage() throws ConfigurationException;

    static <T extends Keyed> T parseKey(Registry<T> registry, String key, String typeName) throws ConfigurationException {
        T type = registry.get(Key.parse(key, "bluemap"));
        if (type == null) {
            Key legacyFormatKey = Key.bluemap(key.toLowerCase(Locale.ROOT));
            type = registry.get(legacyFormatKey);
        }
        if (type == null) {
            throw new ConfigurationException("No " + typeName + " found for key: " + key + "!");
        }
        return type;
    }

    @ConfigSerializable
    public static class Base
    extends StorageConfig {
        @Override
        public Storage createStorage() {
            throw new UnsupportedOperationException();
        }
    }
}

