/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.storage;

import de.bluecolored.bluemap.common.config.storage.FileConfig;
import de.bluecolored.bluemap.common.config.storage.SQLConfig;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;

public interface StorageType
extends Keyed {
    public static final StorageType FILE = new Impl(Key.bluemap("file"), FileConfig.class);
    public static final StorageType SQL = new Impl(Key.bluemap("sql"), SQLConfig.class);
    public static final Registry<StorageType> REGISTRY = new Registry((Keyed[])new StorageType[]{FILE, SQL});

    public Class<? extends StorageConfig> getConfigType();

    public static class Impl
    implements StorageType {
        private final Key key;
        private final Class<? extends StorageConfig> configType;

        public Impl(Key key, Class<? extends StorageConfig> configType) {
            this.key = key;
            this.configType = configType;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public Class<? extends StorageConfig> getConfigType() {
            return this.configType;
        }
    }
}

