/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.logger;

import de.bluecolored.bluemap.core.logger.AbstractLogger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class JavaLogger
extends AbstractLogger {
    private final Logger out;

    public JavaLogger(Logger out) {
        this.out = out;
    }

    @Override
    public void logError(String message, @Nullable Throwable throwable) {
        this.out.log(Level.SEVERE, message, throwable);
    }

    @Override
    public void logWarning(String message) {
        this.out.log(Level.WARNING, message);
    }

    @Override
    public void logInfo(String message) {
        this.out.log(Level.INFO, message);
    }

    @Override
    public void logDebug(String message) {
        if (this.out.isLoggable(Level.FINE)) {
            this.out.log(Level.FINE, message);
        }
    }

    @Override
    public void noFloodDebug(String message) {
        if (this.out.isLoggable(Level.FINE)) {
            super.noFloodDebug(message);
        }
    }

    @Override
    public void noFloodDebug(String key, String message) {
        if (this.out.isLoggable(Level.FINE)) {
            super.noFloodDebug(key, message);
        }
    }

    @Override
    public void close() throws Exception {
        for (Handler handler : this.out.getHandlers()) {
            handler.close();
        }
    }
}

