/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.TileMetaConsumer;
import de.bluecolored.bluemap.core.map.hires.MaxCapacityReachedException;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.TileModel;
import de.bluecolored.bluemap.core.map.hires.TileModelView;
import de.bluecolored.bluemap.core.map.hires.block.BlockStateModelRenderer;
import de.bluecolored.bluemap.core.map.hires.entity.EntityModelRenderer;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.Entity;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.block.Block;
import de.bluecolored.bluemap.core.world.block.BlockNeighborhood;

public class HiresModelRenderer {
    private final ResourcePack resourcePack;
    private final RenderSettings renderSettings;
    private final ThreadLocal<BlockStateModelRenderer> threadLocalBlockRenderer;
    private final ThreadLocal<EntityModelRenderer> threadLocalEntityRenderer;

    public HiresModelRenderer(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
        this.resourcePack = resourcePack;
        this.renderSettings = renderSettings;
        this.threadLocalBlockRenderer = ThreadLocal.withInitial(() -> new BlockStateModelRenderer(resourcePack, textureGallery, renderSettings));
        this.threadLocalEntityRenderer = ThreadLocal.withInitial(() -> new EntityModelRenderer(resourcePack, textureGallery, renderSettings));
    }

    public void render(World world, Vector3i modelMin, Vector3i modelMax, TileModel model) {
        this.render(world, modelMin, modelMax, model, (x, z, c, h2, l) -> {});
    }

    public void render(World world, Vector3i modelMin, Vector3i modelMax, TileModel tileModel, TileMetaConsumer tileMetaConsumer) {
        try {
            Vector3i modelAnchor = new Vector3i(modelMin.getX(), 0, modelMin.getZ());
            BlockStateModelRenderer blockRenderer = this.threadLocalBlockRenderer.get();
            EntityModelRenderer entityRenderer = this.threadLocalEntityRenderer.get();
            Color columnColor = new Color();
            Color blockColor = new Color();
            BlockNeighborhood block = new BlockNeighborhood(new Block(world, 0, 0, 0), this.resourcePack, this.renderSettings, world.getDimensionType());
            TileModelView tileModelView = new TileModelView(tileModel);
            for (int x = modelMin.getX(); x <= modelMax.getX(); ++x) {
                for (int z = modelMin.getZ(); z <= modelMax.getZ(); ++z) {
                    int maxHeight = Integer.MIN_VALUE;
                    double topBlockLight = 0.0;
                    columnColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
                    if (this.renderSettings.isInsideRenderBoundaries(x, z)) {
                        int maxY;
                        Chunk chunk = world.getChunkAtBlock(x, z);
                        int minY = Math.max(modelMin.getY(), chunk.getMinY(x, z));
                        for (int y = maxY = Math.min(modelMax.getY(), chunk.getMaxY(x, z)); y >= minY; --y) {
                            block.set(x, y, z);
                            if (!block.isInsideRenderBounds()) continue;
                            tileModelView.initialize();
                            blockRenderer.render(block, tileModelView, blockColor);
                            topBlockLight = Math.max(topBlockLight, (double)((float)block.getBlockLightLevel() * (1.0f - columnColor.a)));
                            tileModelView.translate(x - modelAnchor.getX(), y - modelAnchor.getY(), z - modelAnchor.getZ());
                            if (blockColor.a > 0.0f) {
                                if (maxHeight < y) {
                                    maxHeight = y;
                                }
                                columnColor.underlay(blockColor.premultiplied());
                            }
                            if (this.renderSettings.isRenderTopOnly() && (double)blockColor.a > 0.999 && block.getProperties().isCulling()) break;
                        }
                    }
                    if (maxHeight == Integer.MIN_VALUE) {
                        maxHeight = 0;
                    }
                    tileMetaConsumer.set(x, z, columnColor, maxHeight, (int)topBlockLight);
                }
            }
            world.iterateEntities(modelMin.getX(), modelMin.getZ(), modelMax.getX(), modelMax.getZ(), entity -> {
                Vector3d pos = entity.getPos();
                block.set(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ());
                entityRenderer.render((Entity)entity, block, tileModelView.initialize());
                tileModelView.translate((float)pos.getX() - (float)modelAnchor.getX(), (float)pos.getY() - (float)modelAnchor.getY(), (float)pos.getZ() - (float)modelAnchor.getZ());
            });
        }
        catch (MaxCapacityReachedException ex) {
            Logger.global.noFloodWarning("max-capacity-reached", "One or more map-tiles are too complex to be completed (@~ %s to %s): %s".formatted(modelMin, modelMax, ex));
        }
    }
}

