/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires.entity;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.TileModelView;
import de.bluecolored.bluemap.core.map.hires.entity.EntityRenderer;
import de.bluecolored.bluemap.core.map.hires.entity.EntityRendererType;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.entitystate.Part;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.Entity;
import de.bluecolored.bluemap.core.world.block.BlockNeighborhood;

public class MissingModelRenderer
implements EntityRenderer {
    private static final LoadingCache<Key, EntityRendererType> ENTITY_RENDERER_TYPES = Caffeine.newBuilder().maximumSize(1000L).build(entityType -> {
        for (EntityRendererType type : EntityRendererType.REGISTRY.values()) {
            if (!type.isFallbackFor((Key)entityType)) continue;
            return type;
        }
        Logger.global.logDebug("No renderer found for entity type: " + String.valueOf(entityType));
        return EntityRendererType.DEFAULT;
    });
    private final LoadingCache<EntityRendererType, EntityRenderer> entityRenderers = Caffeine.newBuilder().build(type -> type.create(resourcePack, textureGallery, renderSettings));

    public MissingModelRenderer(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
    }

    @Override
    public void render(Entity entity, BlockNeighborhood block, Part part, TileModelView tileModel) {
        this.entityRenderers.get(ENTITY_RENDERER_TYPES.get(entity.getId())).render(entity, block, part, tileModel);
    }
}

