/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.bluecolored.bluemap.core.resources.adapter.LocalDateTimeAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionManifest {
    public static final String DOMAIN = "https://piston-meta.mojang.com/";
    public static final String MANIFEST_URL = "https://piston-meta.mojang.com/mc/game/version_manifest.json";
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)LocalDateTime.class), new LocalDateTimeAdapter()).create();
    private static VersionManifest instance;
    private Latest latest;
    private Version[] versions;
    @Nullable
    private transient Map<String, Version> versionMap;
    private transient boolean sorted;

    public static VersionManifest getOrFetch() throws IOException {
        if (instance == null) {
            return VersionManifest.fetch();
        }
        return instance;
    }

    public static VersionManifest fetch() throws IOException {
        try (InputStream in = VersionManifest.openInputStream(MANIFEST_URL);
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            instance = GSON.fromJson((Reader)reader, VersionManifest.class);
        }
        return instance;
    }

    public synchronized Version[] getVersions() {
        if (!this.sorted) {
            Arrays.sort(this.versions, Comparator.reverseOrder());
        }
        return this.versions;
    }

    public synchronized Version getVersion(String id) throws IOException {
        Version version;
        if (this.versionMap == null) {
            this.versionMap = new HashMap<String, Version>();
            for (Version version2 : this.versions) {
                this.versionMap.put(version2.id, version2);
            }
        }
        if ((version = this.versionMap.get(id)) == null) {
            throw new IOException("There is no version '%s' in manifest.".formatted(id));
        }
        return version;
    }

    private static InputStream openInputStream(String urlPath) throws IOException {
        try {
            URL downloadUrl = new URI(urlPath).toURL();
            URLConnection connection = downloadUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            return connection.getInputStream();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public Latest getLatest() {
        return this.latest;
    }

    public static class Version
    implements Comparable<Version> {
        private String id;
        private String type;
        private String url;
        private LocalDateTime time;
        private LocalDateTime releaseTime;
        @Nullable
        private transient VersionDetail detail;

        public synchronized VersionDetail fetchDetail() throws IOException {
            if (this.detail == null) {
                try (InputStream in = VersionManifest.openInputStream(this.url);
                     BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    this.detail = GSON.fromJson((Reader)reader, VersionDetail.class);
                }
            }
            return this.detail;
        }

        @Override
        public int compareTo(@NotNull Version version) {
            return this.releaseTime.compareTo(version.releaseTime);
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public LocalDateTime getTime() {
            return this.time;
        }

        public LocalDateTime getReleaseTime() {
            return this.releaseTime;
        }
    }

    public static class Latest {
        private String release;
        private String snapshot;

        public String getRelease() {
            return this.release;
        }

        public String getSnapshot() {
            return this.snapshot;
        }
    }

    public static class Download {
        private String url;
        private long size;
        private String sha1;

        public InputStream createInputStream() throws IOException {
            return VersionManifest.openInputStream(this.url);
        }

        public String getUrl() {
            return this.url;
        }

        public long getSize() {
            return this.size;
        }

        public String getSha1() {
            return this.sha1;
        }
    }

    public static class Downloads {
        private Download client;
        private Download server;

        public Download getClient() {
            return this.client;
        }

        public Download getServer() {
            return this.server;
        }
    }

    public static class VersionDetail {
        private String id;
        private String type;
        private Downloads downloads;

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public Downloads getDownloads() {
            return this.downloads;
        }
    }
}

