/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;
import java.io.IOException;

public class RegistryAdapter<T extends Keyed>
extends TypeAdapter<T> {
    private final Registry<T> registry;
    private final String defaultNamespace;
    private final T fallback;

    @Override
    public T read(JsonReader in) throws IOException {
        Key key = Key.parse(in.nextString(), this.defaultNamespace);
        T value = this.registry.get(key);
        if (value != null) {
            return value;
        }
        Logger.global.noFloodWarning("unknown-registry-key-" + key.getFormatted(), "Failed to find registry-entry for key: " + String.valueOf(key));
        return this.fallback;
    }

    @Override
    public void write(JsonWriter out, T value) throws IOException {
        out.value(value.getKey().getFormatted());
    }

    public RegistryAdapter(Registry<T> registry, String defaultNamespace, T fallback) {
        this.registry = registry;
        this.defaultNamespace = defaultNamespace;
        this.fallback = fallback;
    }
}

