/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=MinAdapter.class)
public class PackVersion {
    private int major;
    private int minor;

    public boolean isGreaterOrEqual(PackVersion other) {
        if (other.major == this.major) {
            return other.minor >= this.minor;
        }
        return other.major > this.major;
    }

    public boolean isSmallerOrEqual(PackVersion other) {
        if (other.major == this.major) {
            return other.minor <= this.minor;
        }
        return other.major < this.major;
    }

    public PackVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return "PackVersion(major=" + this.getMajor() + ", minor=" + this.getMinor() + ")";
    }

    public static class MaxAdapter
    extends Adapter {
        public MaxAdapter() {
            super(Integer.MAX_VALUE);
        }
    }

    public static class MinAdapter
    extends Adapter {
        public MinAdapter() {
            super(0);
        }
    }

    public static class Adapter
    extends TypeAdapter<PackVersion> {
        private final int defaultMinor;

        public Adapter(int defaultMinor) {
            this.defaultMinor = defaultMinor;
        }

        @Override
        public void write(JsonWriter out, PackVersion value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PackVersion read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NUMBER) {
                return new PackVersion(in.nextInt(), this.defaultMinor);
            }
            in.beginArray();
            int major = in.nextInt();
            int minor = in.hasNext() ? in.nextInt() : this.defaultMinor;
            in.endArray();
            return new PackVersion(major, minor);
        }
    }
}

