/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.adapter.AbstractTypeAdapterFactory;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.resources.pack.ResourcePool;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas.SourceType;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.AnimationMeta;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Key;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Adapter.class)
public class Source {
    private Key type;

    public void load(Path root, ResourcePool<Texture> textures, Predicate<Key> textureFilter) throws IOException {
    }

    public void bake(ResourcePool<Texture> textures, Predicate<Key> textureFilter) throws IOException {
    }

    @Nullable
    protected Texture loadTexture(ResourcePath<Texture> key, Path file) throws IOException {
        BufferedImage image = this.loadImage(file);
        if (image == null) {
            return null;
        }
        AnimationMeta animation = this.loadAnimation(file);
        return Texture.from(key, image, animation);
    }

    @Nullable
    protected BufferedImage loadImage(Path imageFile) throws IOException {
        if (!Files.exists(imageFile, new LinkOption[0])) {
            return null;
        }
        try (InputStream in = Files.newInputStream(imageFile, new OpenOption[0]);){
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
    }

    @Nullable
    protected AnimationMeta loadAnimation(Path imageFile) throws IOException {
        Path animationPathFile = imageFile.resolveSibling(String.valueOf(imageFile.getFileName()) + ".mcmeta");
        if (!Files.exists(animationPathFile, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader in = Files.newBufferedReader(animationPathFile, StandardCharsets.UTF_8);){
            AnimationMeta animationMeta = ResourcesGson.INSTANCE.fromJson((Reader)in, AnimationMeta.class);
            return animationMeta;
        }
    }

    protected Path getFile(Path root, ResourcePath<Texture> key) {
        return root.resolve("assets").resolve(key.getNamespace()).resolve("textures").resolve(key.getValue().replace("/", root.getFileSystem().getSeparator()) + ".png");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this.getClass() != Source.class) {
            return false;
        }
        Source source = (Source)object;
        return this.type.equals(source.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public Key getType() {
        return this.type;
    }

    static class Adapter
    extends AbstractTypeAdapterFactory<Source> {
        public Adapter() {
            super(Source.class);
        }

        @Override
        public Source read(JsonReader in, Gson gson) throws IOException {
            JsonElement element = gson.getAdapter(JsonElement.class).read(in);
            Source base = gson.getDelegateAdapter(this, TypeToken.get(Source.class)).fromJsonTree(element);
            SourceType type = SourceType.REGISTRY.get(base.getType());
            if (type == null) {
                Logger.global.logDebug("Unknown atlas-source type: " + String.valueOf(base.getType()));
                return base;
            }
            return gson.getDelegateAdapter(this, TypeToken.get(type.getType())).fromJsonTree(element);
        }
    }
}

