/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.ResourcePool;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Adapter.class)
public class TextureVariable {
    @Nullable
    private String referenceName;
    private ResourcePath<Texture> texturePath;
    private volatile transient boolean isReference;
    private volatile transient boolean isResolving;

    private TextureVariable(TextureVariable copyFrom) {
        this.referenceName = copyFrom.referenceName;
        this.texturePath = copyFrom.texturePath;
        this.isReference = copyFrom.isReference;
        this.isResolving = copyFrom.isResolving;
    }

    public TextureVariable(String referenceName) {
        this.referenceName = Objects.requireNonNull(referenceName);
        this.texturePath = null;
        this.isReference = true;
        this.isResolving = false;
    }

    public TextureVariable(ResourcePath<Texture> texturePath) {
        this.referenceName = null;
        this.texturePath = Objects.requireNonNull(texturePath);
        this.isReference = false;
        this.isResolving = false;
    }

    @Nullable
    public ResourcePath<Texture> getTexturePath(Function<String, TextureVariable> supplier) {
        if (this.isReference) {
            return this.resolveTexturePath(supplier);
        }
        return this.texturePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourcePath<Texture> resolveTexturePath(Function<String, TextureVariable> supplier) {
        Class<TextureVariable> clazz = TextureVariable.class;
        synchronized (TextureVariable.class) {
            if (this.isReference && !this.isResolving) {
                this.isResolving = true;
                TextureVariable referenced = supplier.apply(this.referenceName);
                if (referenced != null) {
                    this.texturePath = referenced.getTexturePath(supplier);
                }
                this.isReference = false;
                this.isResolving = false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.texturePath;
        }
    }

    public boolean isReference() {
        return this.isReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureVariable copy() {
        Class<TextureVariable> clazz = TextureVariable.class;
        synchronized (TextureVariable.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new TextureVariable(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize(ResourcePool<Texture> texturePool) {
        Class<TextureVariable> clazz = TextureVariable.class;
        synchronized (TextureVariable.class) {
            if (this.texturePath != null) {
                this.texturePath = texturePool.getPath(this.texturePath);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Nullable
    public String getReferenceName() {
        return this.referenceName;
    }

    public ResourcePath<Texture> getTexturePath() {
        return this.texturePath;
    }

    static class Adapter
    extends TypeAdapter<TextureVariable> {
        Adapter() {
        }

        @Override
        public void write(JsonWriter out, TextureVariable value) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public TextureVariable read(JsonReader in) throws IOException {
            String value = in.nextString();
            if (value.isEmpty()) {
                throw new IOException("Can't parse an empty String into a TextureVariable");
            }
            if (value.charAt(0) == '#') {
                return new TextureVariable(value.substring(1));
            }
            if (!value.contains(":") && !value.contains("/")) {
                return new TextureVariable(value);
            }
            return new TextureVariable(new ResourcePath<Texture>(value));
        }
    }
}

