/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.texture;

import com.google.gson.Gson;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.core.resources.adapter.AbstractTypeAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Adapter.class)
public class AnimationMeta {
    private boolean interpolate = false;
    private int width = 1;
    private int height = 1;
    private int frametime = 1;
    @Nullable
    private List<FrameMeta> frames = null;

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrametime() {
        return this.frametime;
    }

    @Nullable
    public List<FrameMeta> getFrames() {
        return this.frames;
    }

    private AnimationMeta() {
    }

    public AnimationMeta(boolean interpolate, int width, int height, int frametime, @Nullable List<FrameMeta> frames) {
        this.interpolate = interpolate;
        this.width = width;
        this.height = height;
        this.frametime = frametime;
        this.frames = frames;
    }

    static class Adapter
    extends AbstractTypeAdapterFactory<AnimationMeta> {
        public Adapter() {
            super(AnimationMeta.class);
        }

        @Override
        public AnimationMeta read(JsonReader in, Gson gson) throws IOException {
            AnimationMeta animationMeta = new AnimationMeta();
            in.beginObject();
            while (in.hasNext()) {
                if (!in.nextName().equals("animation")) {
                    in.skipValue();
                    continue;
                }
                in.beginObject();
                block15: while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "interpolate": {
                            animationMeta.interpolate = in.nextBoolean();
                            continue block15;
                        }
                        case "width": {
                            animationMeta.width = in.nextInt();
                            continue block15;
                        }
                        case "height": {
                            animationMeta.height = in.nextInt();
                            continue block15;
                        }
                        case "frametime": {
                            animationMeta.frametime = (int)in.nextDouble();
                            continue block15;
                        }
                        case "frames": {
                            this.readFramesList(in, animationMeta);
                            continue block15;
                        }
                    }
                    in.skipValue();
                }
                in.endObject();
            }
            in.endObject();
            if (animationMeta.frames != null) {
                for (FrameMeta frameMeta : animationMeta.frames) {
                    if (frameMeta.time != -1) continue;
                    frameMeta.time = animationMeta.frametime;
                }
            }
            return animationMeta;
        }

        private void readFramesList(JsonReader in, AnimationMeta animationMeta) throws IOException {
            ArrayList<FrameMeta> frames = new ArrayList<FrameMeta>();
            in.beginArray();
            while (in.hasNext()) {
                int index = 0;
                int time = -1;
                if (in.peek() == JsonToken.NUMBER) {
                    index = in.nextInt();
                } else {
                    in.beginObject();
                    block9: while (in.hasNext()) {
                        switch (in.nextName()) {
                            case "index": {
                                index = in.nextInt();
                                continue block9;
                            }
                            case "time": {
                                time = (int)in.nextDouble();
                                continue block9;
                            }
                        }
                        in.skipValue();
                    }
                    in.endObject();
                }
                frames.add(new FrameMeta(index, time));
            }
            in.endArray();
            if (!frames.isEmpty()) {
                animationMeta.frames = frames;
            }
        }

        @Override
        public void write(JsonWriter out, AnimationMeta value, Gson gson) throws IOException {
            gson.getDelegateAdapter(this, TypeToken.get(AnimationMeta.class)).write(out, value);
        }
    }

    public static class FrameMeta {
        private int index;
        private int time;

        public int getIndex() {
            return this.index;
        }

        public int getTime() {
            return this.time;
        }

        public FrameMeta(int index, int time) {
            this.index = index;
            this.time = time;
        }
    }
}

