/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.compression;

import de.bluecolored.bluemap.core.storage.compression.BufferedCompression;
import de.bluecolored.bluemap.core.storage.compression.NoCompression;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;
import io.airlift.compress.zstd.ZstdInputStream;
import io.airlift.compress.zstd.ZstdOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;

public interface Compression
extends Keyed {
    public static final Compression NONE = new NoCompression(Key.bluemap("none"), "none", "");
    public static final Compression GZIP = new BufferedCompression(Key.bluemap("gzip"), "gzip", ".gz", GZIPOutputStream::new, GZIPInputStream::new);
    public static final Compression DEFLATE = new BufferedCompression(Key.bluemap("deflate"), "deflate", ".deflate", DeflaterOutputStream::new, InflaterInputStream::new);
    public static final Compression ZSTD = new BufferedCompression(Key.bluemap("zstd"), "zstd", ".zst", ZstdOutputStream::new, ZstdInputStream::new);
    public static final Compression LZ4 = new BufferedCompression(Key.bluemap("lz4"), "lz4", ".lz4", LZ4BlockOutputStream::new, LZ4BlockInputStream::new);
    public static final Registry<Compression> REGISTRY = new Registry((Keyed[])new Compression[]{NONE, GZIP, DEFLATE, ZSTD, LZ4});

    public String getId();

    public String getFileSuffix();

    public OutputStream compress(OutputStream var1) throws IOException;

    public InputStream decompress(InputStream var1) throws IOException;
}

