/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.file;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.storage.ItemStorage;
import de.bluecolored.bluemap.core.storage.MapStorage;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.storage.file.FileGridStorage;
import de.bluecolored.bluemap.core.storage.file.FileItemStorage;
import de.bluecolored.bluemap.core.util.DeletingPathVisitor;
import de.bluecolored.bluemap.core.util.FileHelper;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.function.DoublePredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileMapStorage
implements MapStorage {
    private static final String TILES_PATH = "tiles";
    private static final String RENDER_STATE_PATH = "rstate";
    private static final String LIVE_PATH = "live";
    private final Path root;
    private final Compression compression;
    private final boolean atomic;
    private final GridStorage hiresGridStorage;
    private final LoadingCache<Integer, GridStorage> lowresGridStorages;
    private final GridStorage tileStateStorage;
    private final GridStorage chunkStateStorage;

    public FileMapStorage(Path root, Compression compression, boolean atomic) {
        this.root = root;
        this.compression = compression;
        this.atomic = atomic;
        this.hiresGridStorage = new FileGridStorage(root.resolve(TILES_PATH).resolve("0"), ".prbm" + compression.getFileSuffix(), compression, atomic);
        this.lowresGridStorages = Caffeine.newBuilder().build(lod -> new FileGridStorage(root.resolve(TILES_PATH).resolve(String.valueOf(lod)), ".png", Compression.NONE, atomic));
        this.tileStateStorage = new FileGridStorage(root.resolve(RENDER_STATE_PATH), ".tiles.dat", Compression.GZIP, atomic);
        this.chunkStateStorage = new FileGridStorage(root.resolve(RENDER_STATE_PATH).resolve(""), ".chunks.dat", Compression.GZIP, atomic);
    }

    @Override
    public GridStorage hiresTiles() {
        return this.hiresGridStorage;
    }

    @Override
    public GridStorage lowresTiles(int lod) {
        return this.lowresGridStorages.get(lod);
    }

    @Override
    public GridStorage tileState() {
        return this.tileStateStorage;
    }

    @Override
    public GridStorage chunkState() {
        return this.chunkStateStorage;
    }

    public Path getAssetPath(String name) {
        String[] parts = MapStorage.escapeAssetName(name).split("/");
        Path assetPath = this.root.resolve("assets");
        for (String part : parts) {
            assetPath = assetPath.resolve(part);
        }
        return assetPath;
    }

    @Override
    public ItemStorage asset(String name) {
        return new FileItemStorage(this.getAssetPath(name), Compression.NONE, this.atomic);
    }

    @Override
    public ItemStorage settings() {
        return new FileItemStorage(this.root.resolve("settings.json"), Compression.NONE, this.atomic);
    }

    @Override
    public ItemStorage textures() {
        return new FileItemStorage(this.root.resolve("textures.json" + this.compression.getFileSuffix()), this.compression, this.atomic);
    }

    @Override
    public ItemStorage markers() {
        return new FileItemStorage(this.root.resolve(LIVE_PATH).resolve("markers.json"), Compression.NONE, this.atomic);
    }

    @Override
    public ItemStorage players() {
        return new FileItemStorage(this.root.resolve(LIVE_PATH).resolve("players.json"), Compression.NONE, this.atomic);
    }

    @Override
    public void delete(DoublePredicate onProgress) throws IOException {
        LinkedList subFiles;
        if (!Files.exists(this.root, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> pathStream = FileHelper.walk(this.root, 3, new FileVisitOption[0]);){
            subFiles = pathStream.collect(Collectors.toCollection(LinkedList::new));
        }
        int subFilesCount = subFiles.size();
        while (!subFiles.isEmpty()) {
            Path subFile = (Path)subFiles.getLast();
            Files.walkFileTree(subFile, DeletingPathVisitor.INSTANCE);
            subFiles.removeLast();
            if (onProgress.test(1.0 - (double)subFiles.size() / (double)subFilesCount)) continue;
            return;
        }
        if (Files.exists(this.root, new LinkOption[0])) {
            Files.walkFileTree(this.root, DeletingPathVisitor.INSTANCE);
        }
    }

    @Override
    public boolean exists() throws IOException {
        return Files.exists(this.root, new LinkOption[0]);
    }

    @Override
    public boolean isClosed() {
        return false;
    }
}

