/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.sql;

import de.bluecolored.bluemap.core.storage.ItemStorage;
import de.bluecolored.bluemap.core.storage.compression.CompressedInputStream;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.storage.sql.commandset.CommandSet;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.stream.OnCloseOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.Nullable;

public class SQLItemStorage
implements ItemStorage {
    private final CommandSet sql;
    private final String map;
    private final Key storage;
    private final Compression compression;

    @Override
    public OutputStream write() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        return new OnCloseOutputStream(this.compression.compress(bytes), () -> this.sql.writeItem(this.map, this.storage, this.compression, bytes.toByteArray()));
    }

    @Override
    @Nullable
    public CompressedInputStream read() throws IOException {
        byte[] data = this.sql.readItem(this.map, this.storage, this.compression);
        if (data == null) {
            return null;
        }
        return new CompressedInputStream(new ByteArrayInputStream(data), this.compression);
    }

    @Override
    public void delete() throws IOException {
        this.sql.deleteItem(this.map, this.storage);
    }

    @Override
    public boolean exists() throws IOException {
        return this.sql.hasItem(this.map, this.storage, this.compression);
    }

    @Override
    public boolean isClosed() {
        return this.sql.isClosed();
    }

    public SQLItemStorage(CommandSet sql, String map, Key storage, Compression compression) {
        this.sql = sql;
        this.map = map;
        this.storage = storage;
        this.compression = compression;
    }
}

