/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class Registry<T extends Keyed> {
    private final ConcurrentHashMap<Key, T> entries = new ConcurrentHashMap();
    private final Set<Key> keys = Collections.unmodifiableSet(this.entries.keySet());
    private final Collection<T> values = Collections.unmodifiableCollection(this.entries.values());

    @SafeVarargs
    public Registry(T ... defaultEntries) {
        for (T entry : defaultEntries) {
            this.register(entry);
        }
    }

    public boolean register(T entry) {
        Objects.requireNonNull(entry, "registry entry can not be null");
        return this.entries.putIfAbsent(entry.getKey(), entry) != null;
    }

    @Nullable
    public T get(Key key) {
        return (T)((Keyed)this.entries.get(key));
    }

    public Set<Key> keys() {
        return this.keys;
    }

    public Collection<T> values() {
        return this.values;
    }

    public Registry() {
    }
}

