/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.util.FileHelper;
import de.bluecolored.bluemap.core.util.WatchService;
import de.bluecolored.bluemap.core.world.mca.region.RegionType;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class MCAWorldRegionWatchService
implements de.bluecolored.bluemap.core.util.WatchService<Vector2i> {
    private final Path regionFolder;
    private final WatchService watchService;
    private boolean initialized;

    public MCAWorldRegionWatchService(Path regionFolder) throws IOException {
        this.regionFolder = regionFolder;
        this.watchService = regionFolder.getFileSystem().newWatchService();
    }

    @Override
    @Nullable
    public List<Vector2i> poll() throws IOException {
        if (!this.ensureInitialization()) {
            return null;
        }
        try {
            WatchKey key = this.watchService.poll();
            if (key == null) {
                return null;
            }
            return this.processWatchKey(key);
        }
        catch (ClosedWatchServiceException e) {
            throw new WatchService.ClosedException(e);
        }
    }

    @Override
    @Nullable
    public List<Vector2i> poll(long timeout, TimeUnit unit) throws IOException, InterruptedException {
        long endTime = System.currentTimeMillis() + unit.toMillis(timeout);
        FileHelper.awaitExistence(this.regionFolder, timeout, unit);
        if (!this.ensureInitialization()) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (now >= endTime) {
            return null;
        }
        try {
            WatchKey key = this.watchService.poll(endTime - now, TimeUnit.MILLISECONDS);
            if (key == null) {
                return null;
            }
            return this.processWatchKey(key);
        }
        catch (ClosedWatchServiceException e) {
            throw new WatchService.ClosedException(e);
        }
    }

    @Override
    public List<Vector2i> take() throws IOException, InterruptedException {
        while (!this.ensureInitialization()) {
            FileHelper.awaitExistence(this.regionFolder, 1L, TimeUnit.HOURS);
        }
        try {
            WatchKey key = this.watchService.take();
            return this.processWatchKey(key);
        }
        catch (ClosedWatchServiceException e) {
            throw new WatchService.ClosedException(e);
        }
    }

    private synchronized boolean ensureInitialization() throws IOException {
        if (this.initialized) {
            return true;
        }
        if (!Files.exists(this.regionFolder, new LinkOption[0])) {
            return false;
        }
        this.regionFolder.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        this.initialized = true;
        return true;
    }

    @Override
    public void close() throws IOException {
        this.watchService.close();
    }

    private List<Vector2i> processWatchKey(WatchKey key) {
        try {
            List<Vector2i> list = key.pollEvents().stream().map(event -> {
                Object patt0$temp = event.context();
                if (patt0$temp instanceof Path) {
                    Path path = (Path)patt0$temp;
                    return RegionType.regionForFileName(path.getFileName().toString());
                }
                return null;
            }).filter(Objects::nonNull).toList();
            return list;
        }
        finally {
            key.reset();
        }
    }
}

