/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca;

public class PackedIntArrayAccess {
    private static final int[] DIVISION_MAGIC = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};
    private final int bitsPerElement;
    private final long[] data;
    private final int elementsPerLong;
    private final int indexShift;
    private final long maxValue;
    private final long indexScale;
    private final long indexOffset;

    public PackedIntArrayAccess(long[] data, int elementCount) {
        this(Math.max(data.length * 64 / elementCount, 1), data);
    }

    public PackedIntArrayAccess(int bitsPerElement, long[] data) {
        this.bitsPerElement = bitsPerElement;
        this.data = data;
        this.maxValue = (1L << this.bitsPerElement) - 1L;
        this.elementsPerLong = 64 / this.bitsPerElement;
        int i = 3 * (this.elementsPerLong - 1);
        this.indexScale = Integer.toUnsignedLong(DIVISION_MAGIC[i]);
        this.indexOffset = Integer.toUnsignedLong(DIVISION_MAGIC[i + 1]);
        this.indexShift = DIVISION_MAGIC[i + 2] + 32;
    }

    public int get(int i) {
        int storageIndex = this.storageIndex(i);
        if (storageIndex >= this.data.length) {
            return 0;
        }
        long l = this.data[storageIndex];
        int offset = (i - storageIndex * this.elementsPerLong) * this.bitsPerElement;
        return (int)(l >> offset & this.maxValue);
    }

    private int storageIndex(int i) {
        return (int)((long)i * this.indexScale + this.indexOffset >> this.indexShift);
    }

    public int getCapacity() {
        return this.data.length * this.elementsPerLong;
    }

    public boolean isCorrectSize(int expectedSize) {
        int capacity = this.getCapacity();
        return expectedSize <= capacity && expectedSize + this.elementsPerLong > capacity;
    }
}

