/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.entity.chunk;

import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.world.mca.ChunkLoader;
import de.bluecolored.bluemap.core.world.mca.MCAUtil;
import de.bluecolored.bluemap.core.world.mca.entity.chunk.MCAEntityChunk;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MCAEntityChunkLoader
implements ChunkLoader<MCAEntityChunk> {
    /*
     * Loose catch block
     */
    @Override
    public MCAEntityChunk load(byte[] data, int offset, int length, Compression compression) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(data, offset, length);){
            try (InputStream decompressedIn = compression.decompress(in);){
                MCAEntityChunk mCAEntityChunk = MCAUtil.BLUENBT.read(decompressedIn, MCAEntityChunk.class);
                return mCAEntityChunk;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public MCAEntityChunk emptyChunk() {
        return MCAEntityChunk.EMPTY_CHUNK;
    }

    @Override
    public MCAEntityChunk erroredChunk() {
        return MCAEntityChunk.ERRORED_CHUNK;
    }
}

