/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt;

import de.bluecolored.bluenbt.InstanceCreator;
import de.bluecolored.bluenbt.InstanceCreatorFactory;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.NBTWriter;
import de.bluecolored.bluenbt.NamingStrategy;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeAdapter;
import de.bluecolored.bluenbt.TypeAdapterFactory;
import de.bluecolored.bluenbt.TypeDeserializer;
import de.bluecolored.bluenbt.TypeDeserializerFactory;
import de.bluecolored.bluenbt.TypeResolver;
import de.bluecolored.bluenbt.TypeResolverFactory;
import de.bluecolored.bluenbt.TypeSerializer;
import de.bluecolored.bluenbt.TypeSerializerFactory;
import de.bluecolored.bluenbt.TypeToken;
import de.bluecolored.bluenbt.adapter.ArrayAdapterFactory;
import de.bluecolored.bluenbt.adapter.CollectionAdapterFactory;
import de.bluecolored.bluenbt.adapter.DefaultDeserializerFactory;
import de.bluecolored.bluenbt.adapter.DefaultInstanceCreatorFactory;
import de.bluecolored.bluenbt.adapter.DefaultSerializerFactory;
import de.bluecolored.bluenbt.adapter.EnumAdapterFactory;
import de.bluecolored.bluenbt.adapter.MapAdapterFactory;
import de.bluecolored.bluenbt.adapter.ObjectDeserializer;
import de.bluecolored.bluenbt.adapter.PrimitiveDeserializerFactory;
import de.bluecolored.bluenbt.adapter.PrimitiveSerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class BlueNBT {
    private static final TypeResolver NO_TYPE_RESOLVER = new TypeResolver(){

        public TypeToken getBaseType() {
            throw new UnsupportedOperationException();
        }

        public TypeToken resolve(Object base) {
            throw new UnsupportedOperationException();
        }

        public Iterable getPossibleTypes() {
            throw new UnsupportedOperationException();
        }
    };
    private final List<TypeSerializerFactory> serializerFactories = new ArrayList<TypeSerializerFactory>();
    private final List<TypeDeserializerFactory> deserializerFactories = new ArrayList<TypeDeserializerFactory>();
    private final List<InstanceCreatorFactory> instanceCreatorFactories = new ArrayList<InstanceCreatorFactory>();
    private final List<TypeResolverFactory> typeResolverFactories = new ArrayList<TypeResolverFactory>();
    private final Map<TypeToken<?>, TypeSerializer<?>> typeSerializerMap = new ConcurrentHashMap();
    private final Map<TypeToken<?>, TypeDeserializer<?>> typeDeserializerMap = new ConcurrentHashMap();
    private final Map<TypeToken<?>, InstanceCreator<?>> instanceCreatorMap = new ConcurrentHashMap();
    private final Map<TypeToken<?>, TypeResolver<?, ?>> typeResolverMap = new ConcurrentHashMap();
    private NamingStrategy namingStrategy = NamingStrategy.FIELD_NAME;

    public BlueNBT() {
        this.register(TypeToken.of(Object.class), ObjectDeserializer.INSTANCE);
        this.register(ArrayAdapterFactory.INSTANCE);
        this.register(PrimitiveSerializerFactory.INSTANCE);
        this.register(PrimitiveDeserializerFactory.INSTANCE);
        this.register(EnumAdapterFactory.INSTANCE);
        this.register(CollectionAdapterFactory.INSTANCE);
        this.register(MapAdapterFactory.INSTANCE);
    }

    public synchronized void register(TypeAdapterFactory typeAdapterFactory) {
        this.serializerFactories.add(typeAdapterFactory);
        this.deserializerFactories.add(typeAdapterFactory);
        this.typeSerializerMap.clear();
    }

    public synchronized void register(TypeSerializerFactory typeSerializerFactory) {
        this.serializerFactories.add(typeSerializerFactory);
    }

    public synchronized void register(TypeDeserializerFactory typeDeserializerFactory) {
        this.deserializerFactories.add(typeDeserializerFactory);
    }

    public synchronized void register(InstanceCreatorFactory instanceCreatorFactory) {
        this.instanceCreatorFactories.add(instanceCreatorFactory);
    }

    public synchronized void register(TypeResolverFactory typeResolverFactory) {
        this.typeResolverFactories.add(typeResolverFactory);
    }

    public <T> void register(final TypeToken<T> type, final TypeAdapter<T> typeAdapter) {
        this.register(new TypeAdapterFactory(){

            public <U> Optional<TypeAdapter<U>> create(TypeToken<U> createType, BlueNBT blueNBT) {
                if (createType.equals(type)) {
                    return Optional.of(typeAdapter);
                }
                return Optional.empty();
            }
        });
    }

    public <T> void register(final TypeToken<T> type, final TypeSerializer<T> typeSerializer) {
        this.register(new TypeSerializerFactory(){

            public <U> Optional<TypeSerializer<U>> create(TypeToken<U> createType, BlueNBT blueNBT) {
                if (createType.equals(type)) {
                    return Optional.of(typeSerializer);
                }
                return Optional.empty();
            }
        });
    }

    public <T> void register(final TypeToken<T> type, final TypeDeserializer<T> typeDeserializer) {
        this.register(new TypeDeserializerFactory(){

            public <U> Optional<TypeDeserializer<U>> create(TypeToken<U> createType, BlueNBT blueNBT) {
                if (createType.equals(type)) {
                    return Optional.of(typeDeserializer);
                }
                return Optional.empty();
            }
        });
    }

    public <T> void register(final TypeToken<T> type, final InstanceCreator<T> instanceCreator) {
        this.register(new InstanceCreatorFactory(){

            public <U> Optional<? extends InstanceCreator<U>> create(TypeToken<U> createType, BlueNBT blueNBT) {
                if (createType.equals(type)) {
                    return Optional.of(instanceCreator);
                }
                return Optional.empty();
            }
        });
    }

    public <T> void register(final TypeToken<T> type, final TypeResolver<T, ?> typeResolver) {
        this.register(new TypeResolverFactory(){

            public <U> Optional<? extends TypeResolver<U, ?>> create(TypeToken<U> createType, BlueNBT blueNBT) {
                if (createType.equals(type)) {
                    return Optional.of(typeResolver);
                }
                return Optional.empty();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypeSerializer<T> getTypeSerializer(TypeToken<T> type) {
        TypeSerializer<?> serializer = this.typeSerializerMap.get(type);
        if (serializer != null && !(serializer instanceof FutureTypeSerializer)) {
            return serializer;
        }
        BlueNBT blueNBT = this;
        synchronized (blueNBT) {
            TypeSerializerFactory factory;
            serializer = this.typeSerializerMap.get(type);
            if (serializer != null) {
                return serializer;
            }
            FutureTypeSerializer future = new FutureTypeSerializer();
            this.typeSerializerMap.put(type, future);
            for (int i = this.serializerFactories.size() - 1; i >= 0 && (serializer = (TypeSerializer<?>)(factory = this.serializerFactories.get(i)).create(type, this).orElse(null)) == null; --i) {
            }
            if (serializer == null) {
                serializer = DefaultSerializerFactory.INSTANCE.createFor(type, this);
            }
            future.complete(serializer);
            this.typeSerializerMap.put(type, serializer);
        }
        return serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypeDeserializer<T> getTypeDeserializer(TypeToken<T> type) {
        TypeDeserializer<?> deserializer = this.typeDeserializerMap.get(type);
        if (deserializer != null && !(deserializer instanceof FutureTypeDeserializer)) {
            return deserializer;
        }
        BlueNBT blueNBT = this;
        synchronized (blueNBT) {
            TypeDeserializerFactory factory;
            deserializer = this.typeDeserializerMap.get(type);
            if (deserializer != null) {
                return deserializer;
            }
            FutureTypeDeserializer future = new FutureTypeDeserializer();
            this.typeDeserializerMap.put(type, future);
            for (int i = this.deserializerFactories.size() - 1; i >= 0 && (deserializer = (TypeDeserializer<?>)(factory = this.deserializerFactories.get(i)).create(type, this).orElse(null)) == null; --i) {
            }
            if (deserializer == null) {
                deserializer = DefaultDeserializerFactory.INSTANCE.createFor(type, this);
            }
            future.complete(deserializer);
            this.typeDeserializerMap.put(type, deserializer);
        }
        return deserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> InstanceCreator<T> getInstanceCreator(TypeToken<T> type) {
        InstanceCreator<?> instanceCreator = this.instanceCreatorMap.get(type);
        if (instanceCreator != null && !(instanceCreator instanceof FutureInstanceCreator)) {
            return instanceCreator;
        }
        BlueNBT blueNBT = this;
        synchronized (blueNBT) {
            InstanceCreatorFactory factory;
            instanceCreator = this.instanceCreatorMap.get(type);
            if (instanceCreator != null) {
                return instanceCreator;
            }
            FutureInstanceCreator future = new FutureInstanceCreator();
            this.instanceCreatorMap.put(type, future);
            for (int i = this.instanceCreatorFactories.size() - 1; i >= 0 && (instanceCreator = (InstanceCreator<?>)(factory = this.instanceCreatorFactories.get(i)).create(type, this).orElse(null)) == null; --i) {
            }
            if (instanceCreator == null) {
                instanceCreator = DefaultInstanceCreatorFactory.INSTANCE.createFor(type, this);
            }
            future.complete(instanceCreator);
            this.instanceCreatorMap.put(type, instanceCreator);
        }
        return instanceCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> TypeResolver<T, ?> getTypeResolver(TypeToken<T> type) {
        TypeResolver typeResolver = this.typeResolverMap.get(type);
        if (typeResolver != null && !(typeResolver instanceof FutureInstanceCreator)) {
            return typeResolver;
        }
        BlueNBT blueNBT = this;
        synchronized (blueNBT) {
            TypeResolverFactory factory;
            typeResolver = this.typeResolverMap.get(type);
            if (typeResolver != null) {
                return typeResolver;
            }
            FutureTypeResolver future = new FutureTypeResolver();
            this.typeResolverMap.put(type, future);
            for (int i = this.typeResolverFactories.size() - 1; i >= 0 && (typeResolver = (TypeResolver)(factory = this.typeResolverFactories.get(i)).create(type, this).orElse(null)) == null; --i) {
            }
            if (typeResolver == null) {
                typeResolver = NO_TYPE_RESOLVER;
            }
            future.complete(typeResolver);
            this.typeResolverMap.put(type, typeResolver);
        }
        return typeResolver == NO_TYPE_RESOLVER ? null : typeResolver;
    }

    public <T> void write(T object, OutputStream out, TypeToken<T> type) throws IOException {
        this.write(object, new NBTWriter(out), type);
    }

    public <T> void write(T object, NBTWriter out, TypeToken<T> type) throws IOException {
        this.getTypeSerializer(type).write(object, out);
    }

    public <T> void write(T object, OutputStream out, Class<T> type) throws IOException {
        this.write(object, out, TypeToken.of(type));
    }

    public <T> void write(T object, NBTWriter out, Class<T> type) throws IOException {
        this.write(object, out, TypeToken.of(type));
    }

    public void write(Object object, OutputStream out) throws IOException {
        this.write(object, out, object.getClass());
    }

    public void write(Object object, NBTWriter out) throws IOException {
        this.write(object, out, object.getClass());
    }

    public <T> T read(InputStream in, TypeToken<T> type) throws IOException {
        return this.read(new NBTReader(in), type);
    }

    public <T> T read(NBTReader in, TypeToken<T> type) throws IOException {
        return this.getTypeDeserializer(type).read(in);
    }

    public <T> T read(InputStream in, Class<T> type) throws IOException {
        return this.read(in, TypeToken.of(type));
    }

    public <T> T read(NBTReader in, Class<T> type) throws IOException {
        return this.read(in, TypeToken.of(type));
    }

    public Object read(InputStream in, Type type) throws IOException {
        return this.read(in, TypeToken.of(type));
    }

    public Object read(NBTReader in, Type type) throws IOException {
        return this.read(in, TypeToken.of(type));
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    private static class FutureTypeSerializer<T>
    implements TypeSerializer<T> {
        private TypeSerializer<T> value;

        private FutureTypeSerializer() {
        }

        public void complete(TypeSerializer<T> value) {
            if (this.value != null) {
                throw new IllegalStateException("FutureTypeSerializer already completed!");
            }
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public void write(T value, NBTWriter writer) throws IOException {
            if (this.value == null) {
                throw new IllegalStateException("FutureTypeSerializer not completed!");
            }
            this.value.write(value, writer);
        }

        @Override
        public TagType type() {
            if (this.value == null) {
                throw new IllegalStateException("FutureTypeSerializer is not ready!");
            }
            return this.value.type();
        }
    }

    private static class FutureTypeDeserializer<T>
    implements TypeDeserializer<T> {
        private TypeDeserializer<T> value;

        private FutureTypeDeserializer() {
        }

        public void complete(TypeDeserializer<T> value) {
            if (this.value != null) {
                throw new IllegalStateException("FutureTypeDeserializer already completed!");
            }
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public T read(NBTReader reader) throws IOException {
            if (this.value == null) {
                throw new IllegalStateException("FutureTypeDeserializer is not ready!");
            }
            return this.value.read(reader);
        }
    }

    private static class FutureInstanceCreator<T>
    implements InstanceCreator<T> {
        private InstanceCreator<T> value;

        private FutureInstanceCreator() {
        }

        public void complete(InstanceCreator<T> value) {
            if (this.value != null) {
                throw new IllegalStateException("FutureInstanceCreator already completed!");
            }
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public T create() {
            if (this.value == null) {
                throw new IllegalStateException("FutureInstanceCreator is not ready!");
            }
            return this.value.create();
        }
    }

    private static class FutureTypeResolver<T, B>
    implements TypeResolver<T, B> {
        private TypeResolver<T, B> value;

        private FutureTypeResolver() {
        }

        public void complete(TypeResolver<T, B> value) {
            if (this.value != null) {
                throw new IllegalStateException("FutureTypeResolver already completed!");
            }
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public TypeToken<B> getBaseType() {
            if (this.value == null) {
                throw new IllegalStateException("FutureTypeResolver is not ready!");
            }
            return this.value.getBaseType();
        }

        @Override
        public TypeToken<? extends T> resolve(B base) {
            if (this.value == null) {
                throw new IllegalStateException("FutureTypeResolver is not ready!");
            }
            return this.value.resolve(base);
        }

        @Override
        public Iterable<TypeToken<? extends T>> getPossibleTypes() {
            if (this.value == null) {
                throw new IllegalStateException("FutureTypeResolver is not ready!");
            }
            return this.value.getPossibleTypes();
        }
    }
}

