/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt.adapter;

import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.InstanceCreator;
import de.bluecolored.bluenbt.InstanceCreatorFactory;
import de.bluecolored.bluenbt.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class DefaultInstanceCreatorFactory
implements InstanceCreatorFactory {
    public static final DefaultInstanceCreatorFactory INSTANCE = new DefaultInstanceCreatorFactory();

    @Override
    public <T> Optional<? extends InstanceCreator<T>> create(TypeToken<T> type, BlueNBT blueNBT) {
        return Optional.of(this.createFor(type, blueNBT));
    }

    public <T> InstanceCreator<T> createFor(TypeToken<T> type, BlueNBT blueNBT) {
        try {
            try {
                Constructor constructor = type.getRawType().getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return () -> {
                    try {
                        return constructor.newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new IllegalStateException("Failed to create instance using no-args constructor: " + String.valueOf(constructor), e);
                    }
                };
            }
            catch (NoSuchMethodException constructor) {
                Class<T> rawType = type.getRawType();
                if (type.is(Collection.class)) {
                    if (rawType.isAssignableFrom(ArrayList.class)) {
                        return () -> new ArrayList();
                    }
                    if (rawType.isAssignableFrom(ArrayDeque.class)) {
                        return () -> new ArrayDeque();
                    }
                    if (rawType.isAssignableFrom(LinkedHashSet.class)) {
                        return () -> new LinkedHashSet();
                    }
                    if (rawType.isAssignableFrom(TreeSet.class)) {
                        return () -> new TreeSet();
                    }
                    if (rawType.isAssignableFrom(EnumSet.class)) {
                        Class elementClass;
                        Type elementType = this.getCollectionElementType(type);
                        if (elementType instanceof Class && Enum.class.isAssignableFrom(elementClass = (Class)elementType)) {
                            return () -> EnumSet.noneOf(elementClass);
                        }
                        throw new IllegalStateException("Invalid EnumSet type: " + String.valueOf(type));
                    }
                }
                if (type.is(Map.class)) {
                    if (rawType.isAssignableFrom(HashMap.class)) {
                        return () -> new LinkedHashMap();
                    }
                    if (rawType.isAssignableFrom(TreeMap.class)) {
                        return () -> new TreeMap();
                    }
                    if (rawType.isAssignableFrom(ConcurrentHashMap.class)) {
                        return () -> new ConcurrentHashMap();
                    }
                    if (rawType.isAssignableFrom(ConcurrentSkipListMap.class)) {
                        return () -> new ConcurrentSkipListMap();
                    }
                    if (rawType.isAssignableFrom(EnumMap.class)) {
                        Class keyClass;
                        Type keyType = this.getMapKeyAndValueTypes(type)[0];
                        if (keyType instanceof Class && Enum.class.isAssignableFrom(keyClass = (Class)keyType)) {
                            return () -> new EnumMap(keyClass);
                        }
                        throw new IllegalStateException("Invalid EnumMap type: " + String.valueOf(type));
                    }
                }
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                Object unsafe = unsafeField.get(null);
                Method allocateInstanceMethod = unsafeClass.getMethod("allocateInstance", Class.class);
                return () -> {
                    try {
                        return allocateInstanceMethod.invoke(unsafe, type.getRawType());
                    }
                    catch (ReflectiveOperationException e) {
                        throw new IllegalStateException("Cannot create instance of type: " + String.valueOf(type), e);
                    }
                };
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create Default-InstanceCreator for type: " + String.valueOf(type), ex);
        }
    }

    private Type getCollectionElementType(TypeToken<?> type) {
        Type type2 = type.getSupertype(Collection.class);
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ParameterizedType.class, WildcardType.class}, (Object)type3, n)) {
            case 0 -> {
                ParameterizedType parameterizedType = (ParameterizedType)type3;
                yield parameterizedType.getActualTypeArguments()[0];
            }
            case 1 -> {
                WildcardType wildcardType = (WildcardType)type3;
                yield wildcardType.getUpperBounds()[0];
            }
            default -> Object.class;
        };
    }

    private Type[] getMapKeyAndValueTypes(TypeToken<?> type) {
        Type[] typeArray;
        if (type.is(Properties.class)) {
            return new Type[]{String.class, String.class};
        }
        Type type2 = type.getSupertype(Map.class);
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            typeArray = parameterizedType.getActualTypeArguments();
        } else {
            Type[] typeArray2 = new Type[2];
            typeArray2[0] = Object.class;
            typeArray = typeArray2;
            typeArray2[1] = Object.class;
        }
        return typeArray;
    }
}

