/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbcp2.AbandonedTrace;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingResultSet;
import org.apache.commons.dbcp2.Jdbc41Bridge;
import org.apache.commons.dbcp2.SQLExceptionList;
import org.apache.commons.dbcp2.Utils;

public class DelegatingStatement
extends AbandonedTrace
implements Statement {
    private Statement statement;
    private DelegatingConnection<?> connection;
    private boolean closed;

    public DelegatingStatement(DelegatingConnection<?> connection, Statement statement) {
        super(connection);
        this.statement = statement;
        this.connection = connection;
    }

    public void activate() throws SQLException {
        if (this.statement instanceof DelegatingStatement) {
            ((DelegatingStatement)this.statement).activate();
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        try {
            this.statement.addBatch(sql);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
        try {
            this.statement.cancel();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(this.getClass().getName() + " with address: \"" + this.toString() + "\" is closed.");
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        try {
            this.statement.clearBatch();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        try {
            this.statement.clearWarnings();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        ArrayList<Exception> thrownList = new ArrayList<Exception>();
        try {
            List<AbandonedTrace> resultSetList;
            if (this.connection != null) {
                this.connection.removeTrace(this);
                this.connection = null;
            }
            if ((resultSetList = this.getTrace()) != null) {
                ResultSet[] resultSets;
                for (ResultSet resultSet : resultSets = resultSetList.toArray(Utils.EMPTY_RESULT_SET_ARRAY)) {
                    if (resultSet == null) continue;
                    try {
                        resultSet.close();
                    }
                    catch (Exception e) {
                        if (this.connection != null) {
                            this.connection.handleExceptionNoThrow(e);
                        }
                        thrownList.add(e);
                    }
                }
                this.clearTrace();
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception e) {
                    if (this.connection != null) {
                        this.connection.handleExceptionNoThrow(e);
                    }
                    thrownList.add(e);
                }
            }
        }
        finally {
            this.closed = true;
            this.statement = null;
            if (!thrownList.isEmpty()) {
                throw new SQLExceptionList(thrownList);
            }
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
        try {
            Jdbc41Bridge.closeOnCompletion(this.statement);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.execute(sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeBatch();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeLargeBatch();
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeLargeUpdate(sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0L;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeLargeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0L;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeLargeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0L;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeLargeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0L;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return DelegatingResultSet.wrapResultSet(this, this.statement.executeQuery(sql));
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.getConnectionInternal();
    }

    protected DelegatingConnection<?> getConnectionInternal() {
        return this.connection;
    }

    public Statement getDelegate() {
        return this.statement;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getFetchDirection();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getFetchSize();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this, this.statement.getGeneratedKeys());
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    public Statement getInnermostDelegate() {
        Statement s2 = this.statement;
        while (s2 instanceof DelegatingStatement) {
            if (this != (s2 = ((DelegatingStatement)s2).getDelegate())) continue;
            return null;
        }
        return s2;
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getLargeMaxRows();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0L;
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getLargeUpdateCount();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0L;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getMaxRows();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getMoreResults();
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getMoreResults(current);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getQueryTimeout();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this, this.statement.getResultSet());
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getResultSetType();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getUpdateCount();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getWarnings();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    protected void handleException(SQLException e) throws SQLException {
        if (this.connection == null) {
            throw e;
        }
        this.connection.handleException(e);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    protected boolean isClosedInternal() {
        return this.closed;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        try {
            return Jdbc41Bridge.isCloseOnCompletion(this.statement);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.isPoolable();
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return true;
        }
        if (iface.isAssignableFrom(this.statement.getClass())) {
            return true;
        }
        return this.statement.isWrapperFor(iface);
    }

    public void passivate() throws SQLException {
        if (this.statement instanceof DelegatingStatement) {
            ((DelegatingStatement)this.statement).passivate();
        }
    }

    protected void setClosedInternal(boolean closed) {
        this.closed = closed;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setCursorName(name);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    public void setDelegate(Statement statement) {
        this.statement = statement;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setLargeMaxRows(max);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    private void setLastUsedInParent() {
        if (this.connection != null) {
            this.connection.setLastUsed();
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setMaxRows(max);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setPoolable(poolable);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    public synchronized String toString() {
        return this.statement == null ? "NULL" : this.statement.toString();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        if (iface.isAssignableFrom(this.statement.getClass())) {
            return iface.cast(this.statement);
        }
        return this.statement.unwrap(iface);
    }
}

