/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.RenderManager;
import de.bluecolored.bluemap.api.WebApp;
import de.bluecolored.bluemap.api.plugin.Plugin;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;

public abstract class BlueMapAPI {
    private static final String VERSION;
    private static final String GIT_HASH;
    private static BlueMapAPI instance;
    private static final LinkedHashSet<Consumer<BlueMapAPI>> onEnableConsumers;
    private static final LinkedHashSet<Consumer<BlueMapAPI>> onDisableConsumers;

    public abstract RenderManager getRenderManager();

    public abstract WebApp getWebApp();

    public abstract Plugin getPlugin();

    public abstract Collection<BlueMapMap> getMaps();

    public abstract Collection<BlueMapWorld> getWorlds();

    public abstract Optional<BlueMapWorld> getWorld(Object var1);

    public abstract Optional<BlueMapMap> getMap(String var1);

    public abstract String getBlueMapVersion();

    public String getAPIVersion() {
        return VERSION;
    }

    public static synchronized Optional<BlueMapAPI> getInstance() {
        return Optional.ofNullable(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onEnable(Consumer<BlueMapAPI> consumer) {
        Class<BlueMapAPI> clazz = BlueMapAPI.class;
        synchronized (BlueMapAPI.class) {
            onEnableConsumers.add(consumer);
            BlueMapAPI api = instance;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (api != null) {
                consumer.accept(instance);
            }
            return;
        }
    }

    public static synchronized void onDisable(Consumer<BlueMapAPI> consumer) {
        onDisableConsumers.add(consumer);
    }

    public static synchronized boolean unregisterListener(Consumer<BlueMapAPI> consumer) {
        return onEnableConsumers.remove(consumer) | onDisableConsumers.remove(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    protected static boolean registerInstance(BlueMapAPI instance) throws Exception {
        Class<BlueMapAPI> clazz = BlueMapAPI.class;
        synchronized (BlueMapAPI.class) {
            if (BlueMapAPI.instance != null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return false;
            }
            BlueMapAPI.instance = instance;
            List<Consumer<BlueMapAPI>> consumersToCall = List.copyOf(onEnableConsumers);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return BlueMapAPI.callConsumers(instance, consumersToCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    protected static boolean unregisterInstance(BlueMapAPI instance) throws Exception {
        Class<BlueMapAPI> clazz = BlueMapAPI.class;
        synchronized (BlueMapAPI.class) {
            if (BlueMapAPI.instance != instance) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return false;
            }
            BlueMapAPI.instance = null;
            List<Consumer<BlueMapAPI>> consumersToCall = List.copyOf(onDisableConsumers);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return BlueMapAPI.callConsumers(instance, consumersToCall);
        }
    }

    private static boolean callConsumers(BlueMapAPI instance, List<Consumer<BlueMapAPI>> consumers) throws Exception {
        ArrayList<Exception> thrownExceptions = new ArrayList<Exception>(0);
        for (Consumer<BlueMapAPI> consumer : consumers) {
            try {
                consumer.accept(instance);
            }
            catch (Exception ex) {
                thrownExceptions.add(ex);
            }
        }
        return BlueMapAPI.throwAsOne(thrownExceptions);
    }

    private static boolean throwAsOne(List<Exception> thrownExceptions) throws Exception {
        if (!thrownExceptions.isEmpty()) {
            Exception ex = thrownExceptions.getFirst();
            for (int i = 1; i < thrownExceptions.size(); ++i) {
                ex.addSuppressed(thrownExceptions.get(i));
            }
            throw ex;
        }
        return true;
    }

    static {
        String version = "DEV";
        String gitHash = "DEV";
        URL url = BlueMapAPI.class.getResource("/de/bluecolored/bluemap/api/version.json");
        if (url != null) {
            Gson gson = new Gson();
            try (InputStream in = url.openStream();
                 InputStreamReader reader = new InputStreamReader(in);){
                JsonObject element = gson.fromJson((Reader)reader, JsonElement.class).getAsJsonObject();
                version = element.get("version").getAsString();
                gitHash = element.get("git-hash").getAsString();
            }
            catch (Exception ex) {
                System.err.println("Failed to load version from resources!");
                ex.printStackTrace();
            }
        }
        if (version.equals("${version}")) {
            version = "DEV";
        }
        if (gitHash.equals("${gitHash}")) {
            version = "DEV";
        }
        VERSION = version;
        GIT_HASH = gitHash;
        onEnableConsumers = new LinkedHashSet();
        onDisableConsumers = new LinkedHashSet();
    }
}

