/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.commands;

import de.bluecolored.bluecommands.annotations.Argument;
import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.MapPurgeTask;
import de.bluecolored.bluemap.common.rendermanager.MapRenderTask;
import de.bluecolored.bluemap.common.rendermanager.MapUpdatePreparationTask;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import java.util.LinkedList;
import net.kyori.adventure.text.Component;

public class PurgeCommand {
    private final Plugin plugin;

    @Command(value={"purge <map>"})
    @Permission(value="bluemap.purge")
    public boolean purge(CommandSource source, @Argument(value="map") BmMap map) {
        try {
            boolean updateMap = this.plugin.getPluginState().getMapState(map).isUpdateEnabled();
            MapPurgeTask purgeTask = new MapPurgeTask(map);
            this.plugin.getRenderManager().removeRenderTasksIf(task -> {
                MapRenderTask mrt;
                return task instanceof MapRenderTask && (mrt = (MapRenderTask)task).getMap().equals(map);
            });
            this.plugin.getRenderManager().scheduleRenderTaskNext(purgeTask);
            LinkedList<Component> lines = new LinkedList<Component>();
            lines.add(TextFormat.format("Scheduled a new task to purge map %", TextFormat.formatMap(map).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.POSITIVE_COLOR));
            lines.add(TextFormat.format("Use % to see the progress", TextFormat.command("/bluemap").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
            if (updateMap) {
                lines.add(Component.empty());
                lines.add(TextFormat.format("BlueMap will automatically start rendering the map again once the purge is done\nIf you don't want this, use % before purging\n".strip(), TextFormat.command("/bluemap freeze " + map.getId()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
            }
            source.sendMessage(TextFormat.lines(lines));
            if (updateMap) {
                this.plugin.getRenderManager().scheduleRenderTask(MapUpdatePreparationTask.updateMap(map, this.plugin.getRenderManager()));
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            Logger.global.logError("Failed to purge map '" + map.getId() + "'!", e);
            source.sendMessage(TextFormat.format("There was an error trying to purge %, see console for details.", TextFormat.formatMap(map).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.NEGATIVE_COLOR));
            return false;
        }
    }

    public PurgeCommand(Plugin plugin) {
        this.plugin = plugin;
    }
}

