/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.commands;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluecommands.annotations.Argument;
import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.WithPosition;
import de.bluecolored.bluemap.common.commands.WithWorld;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.MapUpdatePreparationTask;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.common.rendermanager.TileUpdateStrategy;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.world.World;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class UpdateCommand {
    private final Plugin plugin;
    private final TileUpdateStrategy updateStrategy;

    @Command(value={""})
    @Permission(value="bluemap.update")
    @WithWorld
    public boolean update(CommandSource source, World world) throws IOException {
        return this.update(source, world, null, null);
    }

    @Command(value={"<radius>"})
    @Permission(value="bluemap.update")
    @WithWorld
    @WithPosition
    public boolean update(CommandSource source, World world, Vector3d position, @Argument(value="radius") int radius) throws IOException {
        return this.update(source, world, position.toVector2(true).toInt(), (Integer)radius);
    }

    @Command(value={"<x> <z> <radius>"})
    @Permission(value="bluemap.update")
    @WithWorld
    public boolean update(CommandSource source, World world, @Argument(value="x") int x, @Argument(value="z") int z, @Argument(value="radius") int radius) throws IOException {
        return this.update(source, world, new Vector2i(x, z), (Integer)radius);
    }

    @Command(value={"<map>"})
    @Permission(value="bluemap.update")
    public boolean update(CommandSource source, @Argument(value="map") BmMap map) throws IOException {
        return this.update(source, map.getWorld(), List.of(map), null, null);
    }

    @Command(value={"<map> <radius>"})
    @Permission(value="bluemap.update")
    @WithWorld
    @WithPosition
    public boolean update(CommandSource source, World world, Vector3d position, @Argument(value="map") BmMap map, @Argument(value="radius") int radius) throws IOException {
        if (!map.getWorld().equals(world)) {
            source.sendMessage(Component.text("The map does not belong to the same world you are currently in!").color(TextFormat.NEGATIVE_COLOR));
            return false;
        }
        return this.update(source, map.getWorld(), List.of(map), position.toVector2(true).toInt(), (Integer)radius);
    }

    @Command(value={"<map> <x> <z> <radius>"})
    @Permission(value="bluemap.update")
    public boolean update(CommandSource source, @Argument(value="map") BmMap map, @Argument(value="x") int x, @Argument(value="z") int z, @Argument(value="radius") int radius) throws IOException {
        return this.update(source, map.getWorld(), List.of(map), new Vector2i(x, z), (Integer)radius);
    }

    private boolean update(CommandSource source, World world, @Nullable Vector2i center, @Nullable Integer radius) throws IOException {
        ArrayList<BmMap> maps = new ArrayList<BmMap>();
        for (BmMap map2 : this.plugin.getBlueMap().getMaps().values()) {
            if (!map2.getWorld().equals(world)) continue;
            maps.add(map2);
        }
        if (maps.isEmpty()) {
            source.sendMessage(Component.text("No map has been found for this world that could be updated!").color(TextFormat.NEGATIVE_COLOR));
            return false;
        }
        maps.sort(Comparator.comparing(map -> map.getMapSettings().getSorting()));
        return this.update(source, world, maps, center, radius);
    }

    private boolean update(CommandSource source, World world, Collection<BmMap> maps, @Nullable Vector2i center, @Nullable Integer radius) throws IOException {
        source.sendMessage(Component.text("Creating update-tasks ...").color(TextFormat.INFO_COLOR));
        this.plugin.flushWorldUpdates(world);
        this.plugin.getRenderManager().scheduleRenderTasksNext((RenderTask[])maps.stream().map(map -> MapUpdatePreparationTask.builder().map((BmMap)map).center(center).radius(radius).force(this.updateStrategy).taskConsumer(this.plugin.getRenderManager()::scheduleRenderTask).build()).peek(task -> source.sendMessage(TextFormat.format("Created new update-task for map %", TextFormat.formatMap(task.getMap()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.POSITIVE_COLOR))).toArray(RenderTask[]::new));
        source.sendMessage(TextFormat.format("Use % to see the progress", TextFormat.command("/bluemap").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
        return true;
    }

    public UpdateCommand(Plugin plugin, TileUpdateStrategy updateStrategy) {
        this.plugin = plugin;
        this.updateStrategy = updateStrategy;
    }
}

