/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.common.config.ConfigLoader;
import de.bluecolored.bluemap.common.config.ConfigTemplate;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.mask.MaskConfig;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.common.config.typeserializer.CombinedMaskSerializer;
import de.bluecolored.bluemap.common.config.typeserializer.KeyTypeSerializer;
import de.bluecolored.bluemap.common.config.typeserializer.ObjectMapperSerializer;
import de.bluecolored.bluemap.common.config.typeserializer.Vector2dTypeSerializer;
import de.bluecolored.bluemap.common.config.typeserializer.Vector2iTypeSerializer;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.map.mask.CombinedMask;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluenbt.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.serialize.SerializationException;

public class ConfigManager {
    private static final String CONFIG_TEMPLATE_RESOURCE_PATH = "/de/bluecolored/bluemap/config/";
    private final Path configRoot;

    public ConfigManager(Path configRoot) {
        this.configRoot = configRoot;
    }

    public <T> T loadConfig(String name, Class<T> type) throws ConfigurationException {
        Path file = this.resolveConfigFile(name);
        return this.loadConfig(file, type);
    }

    public <T> T loadConfig(Path file, Class<T> type) throws ConfigurationException {
        ConfigurationNode configNode = this.loadConfigFile(file);
        try {
            return Objects.requireNonNull(configNode.get(type));
        }
        catch (NullPointerException | SerializationException ex) {
            throw new ConfigurationException("BlueMap failed to parse this file:\n" + String.valueOf(file) + "\nCheck if the file is correctly formatted and all values are correct!", ex);
        }
    }

    public ConfigTemplate loadConfigTemplate(String name) throws IOException {
        String resource = CONFIG_TEMPLATE_RESOURCE_PATH + name + ConfigLoader.DEFAULT.getFileSuffix();
        try (InputStream in = BlueMap.class.getResourceAsStream(resource);){
            if (in == null) {
                throw new IOException("Resource not found: " + resource);
            }
            StringWriter writer = new StringWriter();
            InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
            reader.transferTo(writer);
            ConfigTemplate configTemplate = new ConfigTemplate(writer.toString());
            return configTemplate;
        }
    }

    public Path resolveConfigFile(String name) {
        for (ConfigLoader configLoader : ConfigLoader.REGISTRY.values()) {
            Path path = this.configRoot.resolve(name + configLoader.getFileSuffix());
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            return path;
        }
        return this.configRoot.resolve(name + ConfigLoader.DEFAULT.getFileSuffix());
    }

    public boolean isConfigFile(Path file) {
        String fileName = file.getFileName().toString();
        for (ConfigLoader configLoader : ConfigLoader.REGISTRY.values()) {
            if (!fileName.endsWith(configLoader.getFileSuffix())) continue;
            return true;
        }
        return false;
    }

    public String getConfigName(Path file) {
        String fileName = file.getFileName().toString();
        for (ConfigLoader configLoader : ConfigLoader.REGISTRY.values()) {
            String suffix = configLoader.getFileSuffix();
            if (!fileName.endsWith(suffix)) continue;
            return fileName.substring(0, fileName.length() - suffix.length());
        }
        return fileName;
    }

    public Path getConfigRoot() {
        return this.configRoot;
    }

    private ConfigurationNode loadConfigFile(Path path) throws ConfigurationException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ConfigurationException("BlueMap tried to find this file, but it does not exist:\n" + String.valueOf(path));
        }
        if (!Files.isReadable(path)) {
            throw new ConfigurationException("BlueMap tried to read this file, but can not access it:\n" + String.valueOf(path) + "\nCheck if BlueMap has the permission to read this file.");
        }
        try {
            return this.getLoader(path).load();
        }
        catch (ConfigurateException ex) {
            throw new ConfigurationException("BlueMap failed to parse this file:\n" + String.valueOf(path) + "\nCheck if the file is correctly formatted.\n(for example there might be a } or ] or , missing somewhere)", ex);
        }
    }

    private ConfigurationLoader<? extends ConfigurationNode> getLoader(Path path) {
        AbstractConfigurationLoader.Builder<?, ?> builder = null;
        for (ConfigLoader loader : ConfigLoader.REGISTRY.values()) {
            if (!path.getFileName().endsWith(loader.getFileSuffix())) continue;
            builder = loader.createLoaderBuilder();
            break;
        }
        if (builder == null) {
            builder = ConfigLoader.DEFAULT.createLoaderBuilder();
        }
        return ((AbstractConfigurationLoader.Builder)((AbstractConfigurationLoader.Builder)builder.path(path)).defaultOptions(o -> o.serializers(b -> {
            b.register(Vector2i.class, new Vector2iTypeSerializer());
            b.register(Vector2d.class, new Vector2dTypeSerializer());
            b.register(Key.class, new KeyTypeSerializer());
            b.register(CombinedMask.class, new CombinedMaskSerializer());
            b.register(type -> TypeToken.of(type).is(StorageConfig.class), new ObjectMapperSerializer());
            b.register(type -> TypeToken.of(type).is(MaskConfig.class), new ObjectMapperSerializer());
        }))).build();
    }
}

