/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.mask;

import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.mask.MaskConfig;
import de.bluecolored.bluemap.core.map.mask.BoxMask;
import de.bluecolored.bluemap.core.map.mask.Mask;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;

@ConfigSerializable
public class BoxMaskConfig
extends MaskConfig {
    private int minX = Integer.MIN_VALUE;
    private int minY = Integer.MIN_VALUE;
    private int minZ = Integer.MIN_VALUE;
    private int maxX = Integer.MAX_VALUE;
    private int maxY = Integer.MAX_VALUE;
    private int maxZ = Integer.MAX_VALUE;

    @Override
    public Mask createMask() throws ConfigurationException {
        if (this.minX > this.maxX || this.minY > this.maxY || this.minZ > this.maxZ) {
            throw new ConfigurationException("The box-mask configuration results in a degenerate mask.\nMake sure that all \"min-\" values are actually SMALLER than their \"max-\" counterparts.\n".trim());
        }
        return new BoxMask(new Vector3i(this.minX, this.minY, this.minZ), new Vector3i(this.maxX, this.maxY, this.maxZ));
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }
}

