/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.mask;

import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.mask.MaskConfig;
import de.bluecolored.bluemap.core.map.mask.EllipseMask;
import de.bluecolored.bluemap.core.map.mask.Mask;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;

@ConfigSerializable
public class CircleMaskConfig
extends MaskConfig {
    private double centerX = 0.0;
    private double centerZ = 0.0;
    private double radius = Double.MAX_VALUE;
    private int minY = Integer.MIN_VALUE;
    private int maxY = Integer.MAX_VALUE;

    @Override
    public Mask createMask() throws ConfigurationException {
        if (this.minY > this.maxY) {
            throw new ConfigurationException("The circle-mask configuration results in a degenerate mask.\nMake sure that the \"min-y\" value is actually SMALLER than the \"max-y\" counterpart.\n".trim());
        }
        if (this.radius <= 0.0) {
            throw new ConfigurationException("The circle-mask configuration results in a degenerate mask.\nMake sure that the \"radius\" value is greater than 0.\n".trim());
        }
        return new EllipseMask(new Vector2d(this.centerX, this.centerZ), this.radius, this.minY, this.maxY);
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterZ() {
        return this.centerZ;
    }

    public double getRadius() {
        return this.radius;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }
}

