/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.storage;

import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.storage.Dialect;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.common.debug.DebugDump;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.storage.sql.Database;
import de.bluecolored.bluemap.core.storage.sql.SQLStorage;
import de.bluecolored.bluemap.core.storage.sql.commandset.CommandSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Driver;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;

@ConfigSerializable
public class SQLConfig
extends StorageConfig {
    @DebugDump(exclude=true)
    private String connectionUrl = "jdbc:mysql://localhost/bluemap?permitMysqlScheme";
    @DebugDump(exclude=true)
    private Map<String, String> connectionProperties = new HashMap<String, String>();
    private String dialect = null;
    private String driverJar = null;
    private String driverClass = null;
    private int maxConnections = -1;
    private String compression = Compression.GZIP.getKey().getFormatted();
    private transient URL driverJarURL = null;

    public Optional<URL> getDriverJar() throws ConfigurationException {
        try {
            if (this.driverJar == null) {
                return Optional.empty();
            }
            if (this.driverJarURL == null) {
                this.driverJarURL = Paths.get(this.driverJar, new String[0]).toUri().toURL();
            }
            return Optional.of(this.driverJarURL);
        }
        catch (MalformedURLException ex) {
            throw new ConfigurationException("The configured driver-jar path is not formatted correctly!\nPlease check your 'driver-jar' setting in your configuration and make sure you have the correct path configured.\n".strip(), ex);
        }
    }

    public Optional<String> getDriverClass() {
        return Optional.ofNullable(this.driverClass);
    }

    public Compression getCompression() throws ConfigurationException {
        return SQLConfig.parseKey(Compression.REGISTRY, this.compression, "compression");
    }

    public Dialect getDialect() throws ConfigurationException {
        String key = this.dialect;
        if (key == null) {
            for (Dialect d : Dialect.REGISTRY.values()) {
                if (!d.supports(this.connectionUrl)) continue;
                key = d.getKey().getFormatted();
                break;
            }
            if (key == null) {
                throw new ConfigurationException("Could not find any sql-dialect that is matching the given connection-url.\nPlease check your 'connection-url' setting in your configuration and make sure it is in the correct format.\n".strip());
            }
        }
        return SQLConfig.parseKey(Dialect.REGISTRY, key, "dialect");
    }

    @Override
    public SQLStorage createStorage() throws ConfigurationException {
        Driver driver = this.createDriver();
        Database database = driver != null ? new Database(this.getConnectionUrl(), this.getConnectionProperties(), this.getMaxConnections(), driver) : new Database(this.getConnectionUrl(), this.getConnectionProperties(), this.getMaxConnections());
        CommandSet commandSet = this.getDialect().createCommandSet(database);
        return new SQLStorage(commandSet, this.getCompression());
    }

    @Nullable
    private Driver createDriver() throws ConfigurationException {
        if (this.driverClass == null) {
            return null;
        }
        try {
            Class<?> driverClazz;
            URL driverJarUrl = this.getDriverJar().orElse(null);
            if (driverJarUrl != null) {
                if (!Files.exists(Path.of(driverJarUrl.toURI()), new LinkOption[0])) {
                    throw new ConfigurationException("The configured driver-jar was not found!\nPlease check your 'driver-jar' setting in your configuration and make sure you have the correct path configured.\n".strip());
                }
                URLClassLoader classLoader = new URLClassLoader(new URL[]{driverJarUrl});
                driverClazz = Class.forName(this.driverClass, true, classLoader);
            } else {
                driverClazz = Class.forName(this.driverClass);
            }
            return (Driver)driverClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException ex) {
            throw new ConfigurationException("The configured driver-class was found but is not of the correct class-type!\nPlease check your 'driver-class' setting in your configuration and make sure you have the correct class configured.\n".strip(), ex);
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationException("The configured driver-class was not found!\nPlease check your 'driver-class' setting in your configuration and make sure you have the correct class configured.\n".strip(), ex);
        }
        catch (ConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurationException("BlueMap failed to load the configured SQL-Driver!\nPlease check your 'driver-jar' and 'driver-class' settings in your configuration.\n".strip(), ex);
        }
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }
}

