/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.rendermanager;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ProgressTracker {
    private static final AtomicInteger ID = new AtomicInteger(0);
    private final Timer timer = new Timer("BlueMap-ProgressTracker-Timer-" + ID.getAndIncrement(), true);
    private Supplier<Double> progressSupplier = () -> 0.0;
    private final int averagingCount;
    private long lastTime;
    private double lastProgress;
    private final Deque<Long> timesPerProgress;

    public ProgressTracker(long updateIntervall, int averagingCount) {
        this.averagingCount = averagingCount;
        this.timesPerProgress = new LinkedList<Long>();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ProgressTracker.this.update();
            }
        }, updateIntervall, updateIntervall);
    }

    public synchronized void resetAndStart(Supplier<Double> progressSupplier) {
        this.progressSupplier = progressSupplier;
        this.lastTime = System.currentTimeMillis();
        this.lastProgress = progressSupplier.get();
        this.timesPerProgress.clear();
    }

    public synchronized long getAverageTimePerProgress() {
        return this.timesPerProgress.stream().collect(Collectors.averagingLong(Long::longValue)).longValue();
    }

    private synchronized void update() {
        long now = System.currentTimeMillis();
        double progress = this.progressSupplier.get();
        long deltaTime = now - this.lastTime;
        double deltaProgress = progress - this.lastProgress;
        if (deltaProgress != 0.0) {
            long totalDuration = (long)((double)deltaTime / deltaProgress);
            this.timesPerProgress.addLast(totalDuration);
            while (this.timesPerProgress.size() > this.averagingCount) {
                this.timesPerProgress.removeFirst();
            }
            this.lastTime = now;
            this.lastProgress = progress;
        }
    }

    public void cancel() {
        this.timer.cancel();
    }
}

