/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map;

import com.flowpowered.math.vector.Vector2i;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.map.lowres.LowresTileManager;
import de.bluecolored.bluemap.core.util.math.Color;
import java.lang.reflect.Type;

public class MapSettingsSerializer
implements JsonSerializer<BmMap> {
    @Override
    public JsonElement serialize(BmMap map, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject root = new JsonObject();
        root.addProperty("name", map.getName());
        root.addProperty("sorting", map.getMapSettings().getSorting());
        Vector2i hiresTileSize = map.getHiresModelManager().getTileGrid().getGridSize();
        Vector2i gridOrigin = map.getHiresModelManager().getTileGrid().getOffset();
        JsonObject hires = new JsonObject();
        hires.add("tileSize", context.serialize(hiresTileSize));
        hires.add("scale", context.serialize(Vector2i.ONE));
        hires.add("translate", context.serialize(gridOrigin));
        root.add("hires", hires);
        LowresTileManager lowresTileManager = map.getLowresTileManager();
        JsonObject lowres = new JsonObject();
        lowres.add("tileSize", context.serialize(lowresTileManager.getTileGrid().getGridSize()));
        lowres.add("lodFactor", context.serialize(lowresTileManager.getLodFactor()));
        lowres.add("lodCount", context.serialize(lowresTileManager.getLodCount()));
        root.add("lowres", lowres);
        root.add("startPos", context.serialize(map.getMapSettings().getStartPos()));
        Color skyColor = new Color().parse(map.getMapSettings().getSkyColor());
        root.add("skyColor", context.serialize(skyColor));
        Color voidColor = new Color().parse(map.getMapSettings().getVoidColor());
        root.add("voidColor", context.serialize(voidColor));
        root.addProperty("ambientLight", Float.valueOf(map.getMapSettings().getAmbientLight()));
        root.addProperty("skyLight", Float.valueOf(map.getMapSettings().getSkyLight()));
        root.addProperty("perspectiveView", map.getMapSettings().isEnablePerspectiveView());
        root.addProperty("flatView", map.getMapSettings().isEnableFlatView());
        root.addProperty("freeFlightView", map.getMapSettings().isEnableFreeFlightView());
        return root;
    }
}

