/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.resources.pack.ResourcePool;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TextureGallery {
    private static final Gson GSON = ResourcesGson.addAdapter(new GsonBuilder()).setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).create();
    private final Map<ResourcePath<Texture>, TextureMapping> textureMappings = new HashMap<ResourcePath<Texture>, TextureMapping>();
    private int nextId = 0;

    public void clear() {
        this.textureMappings.clear();
        this.nextId = 0;
    }

    public int get(@Nullable ResourcePath<Texture> textureResourcePath) {
        TextureMapping mapping;
        if (textureResourcePath == null) {
            textureResourcePath = ResourcePack.MISSING_TEXTURE;
        }
        return (mapping = this.textureMappings.get(textureResourcePath)) != null ? mapping.getId() : 0;
    }

    public synchronized void put(ResourcePath<Texture> textureResourcePath) {
        this.textureMappings.compute(textureResourcePath, (r, mapping) -> {
            if (mapping == null) {
                return new TextureMapping(this.nextId++, (Texture)textureResourcePath.getResource());
            }
            Texture texture = (Texture)textureResourcePath.getResource();
            if (texture != null) {
                mapping.setTexture(texture);
            }
            return mapping;
        });
    }

    public synchronized void put(ResourcePool<Texture> texturePool) {
        this.put(ResourcePack.MISSING_TEXTURE);
        texturePool.paths().stream().sorted(Comparator.comparing(r -> {
            Texture texture = r.getResource(texturePool::get);
            return texture != null && texture.getColorPremultiplied().a < 1.0f;
        }).thenComparing(Key::getFormatted)).forEach(this::put);
    }

    public void writeTexturesFile(OutputStream out) throws IOException {
        Object[] textures = new Texture[this.nextId];
        Arrays.fill(textures, Texture.MISSING);
        this.textureMappings.forEach((arg_0, arg_1) -> TextureGallery.lambda$writeTexturesFile$2((Texture[])textures, arg_0, arg_1));
        try (OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            GSON.toJson((Object)textures, (Type)((Object)Texture[].class), writer);
        }
        catch (JsonIOException ex) {
            throw new IOException(ex);
        }
    }

    public static TextureGallery readTexturesFile(InputStream in) throws IOException {
        TextureGallery gallery = new TextureGallery();
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            Texture[] textures = GSON.fromJson((Reader)reader, Texture[].class);
            if (textures == null) {
                throw new IOException("Texture data is empty!");
            }
            gallery.nextId = textures.length;
            for (int ordinal = 0; ordinal < textures.length; ++ordinal) {
                Texture texture = textures[ordinal];
                if (texture == null) continue;
                gallery.textureMappings.put((ResourcePath<Texture>)texture.getKey(), new TextureMapping(ordinal, texture));
            }
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
        return gallery;
    }

    private static /* synthetic */ void lambda$writeTexturesFile$2(Texture[] textures, ResourcePath textureResourcePath, TextureMapping mapping) {
        int ordinal = mapping.getId();
        Texture texture = mapping.getTexture();
        if (texture == null) {
            texture = Texture.missing(textureResourcePath);
        }
        textures[ordinal] = texture;
    }

    static class TextureMapping {
        private final int id;
        @Nullable
        private Texture texture;

        public TextureMapping(int id, @Nullable Texture texture) {
            this.id = id;
            this.texture = texture;
        }

        public int getId() {
            return this.id;
        }

        @Nullable
        public Texture getTexture() {
            return this.texture;
        }

        public void setTexture(@Nullable Texture texture) {
            this.texture = texture;
        }
    }
}

