/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires.block;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.TileModelView;
import de.bluecolored.bluemap.core.map.hires.block.BlockRenderer;
import de.bluecolored.bluemap.core.map.hires.block.BlockRendererType;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.BlockState;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.Variant;
import de.bluecolored.bluemap.core.util.Caches;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.block.BlockNeighborhood;
import java.util.ArrayList;
import java.util.List;

public class BlockStateModelRenderer {
    private final ResourcePack resourcePack;
    private final LoadingCache<BlockRendererType, BlockRenderer> blockRenderers;
    private final List<Variant> variants = new ArrayList<Variant>();
    private final Color waterloggedColor = new Color();
    private final Color variantColor = new Color();

    public BlockStateModelRenderer(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
        this.resourcePack = resourcePack;
        this.blockRenderers = Caches.build(type -> type.create(resourcePack, textureGallery, renderSettings));
    }

    public void render(BlockNeighborhood block, TileModelView blockModel, Color blockColor) {
        this.render(block, block.getBlockState(), blockModel, blockColor);
    }

    public void render(BlockNeighborhood block, de.bluecolored.bluemap.core.world.BlockState blockState, TileModelView tileModel, Color blockColor) {
        blockColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
        if (blockState.isAir()) {
            return;
        }
        int modelStart = tileModel.getStart();
        this.renderModel(block, blockState, tileModel.initialize(), blockColor);
        if (blockState.isWaterlogged() || block.getProperties().isAlwaysWaterlogged()) {
            this.waterloggedColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
            this.renderModel(block, de.bluecolored.bluemap.core.world.BlockState.WATER, tileModel.initialize(), this.waterloggedColor);
            blockColor.set(this.waterloggedColor.overlay(blockColor.premultiplied()));
        }
        tileModel.initialize(modelStart);
    }

    private void renderModel(BlockNeighborhood block, de.bluecolored.bluemap.core.world.BlockState blockState, TileModelView tileModel, Color blockColor) {
        int modelStart = tileModel.getStart();
        BlockState stateResource = this.resourcePack.getBlockState(blockState);
        if (stateResource == null) {
            return;
        }
        float blockColorOpacity = 0.0f;
        this.variants.clear();
        stateResource.forEach(blockState, block.getX(), block.getY(), block.getZ(), this.variants::add);
        for (int i = 0; i < this.variants.size(); ++i) {
            this.variantColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
            Variant variant = this.variants.get(i);
            this.blockRenderers.get(variant.getRenderer()).render(block, variant, tileModel.initialize(), this.variantColor);
            if (this.variantColor.a > blockColorOpacity) {
                blockColorOpacity = this.variantColor.a;
            }
            blockColor.add(this.variantColor.premultiplied());
        }
        if (blockColor.a > 0.0f) {
            blockColor.flatten().straight();
            blockColor.a = blockColorOpacity;
        }
        tileModel.initialize(modelStart);
    }
}

