/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires.block;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.TileModelView;
import de.bluecolored.bluemap.core.map.hires.block.BlockRenderer;
import de.bluecolored.bluemap.core.map.hires.block.BlockRendererType;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.Variant;
import de.bluecolored.bluemap.core.util.Caches;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.block.BlockNeighborhood;

public class MissingModelRenderer
implements BlockRenderer {
    private static final LoadingCache<BlockState, BlockRendererType> BLOCK_RENDERER_TYPES = Caches.build(blockState -> {
        for (BlockRendererType type : BlockRendererType.REGISTRY.values()) {
            if (!type.isFallbackFor((BlockState)blockState)) continue;
            return type;
        }
        Logger.global.logDebug("No renderer found for block state: " + String.valueOf(blockState));
        return BlockRendererType.DEFAULT;
    });
    private final LoadingCache<BlockRendererType, BlockRenderer> blockRenderers = Caches.build(type -> type.create(resourcePack, textureGallery, renderSettings));

    public MissingModelRenderer(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
    }

    @Override
    public void render(BlockNeighborhood block, Variant variant, TileModelView blockModel, Color blockColor) {
        this.blockRenderers.get(BLOCK_RENDERER_TYPES.get(block.getBlockState())).render(block, variant, blockModel, blockColor);
    }
}

